Group: Development/Tools
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           examiner
Version:        0.5
Release:        alt2_34
Summary:        Utility to disassemble and comment foreign executable binaries 

License:        GPLv2
URL:            http://www.academicunderground.org/examiner
Source0:        http://www.academicunderground.org/examiner/%{name}-%{version}.tar.gz
Patch0:         examiner-0.5-examiner_hashes_pl.patch
BuildArch:      noarch

BuildRequires:  /usr/bin/pod2man
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
# Required perl modules.
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Env.pm)
BuildRequires:  perl(Getopt/Std.pm)
BuildRequires:  perl(File/Basename.pm)
Source44: import.info


%description
The Examiner is an application that utilizes the objdump command to disassemble
and comment foreign executable binaries. This app was designed to analyze static
compiled binaries but works ok with others. The intention is for forensic
research but could also be used in general reverse engineering.
This program can only handle basic dissassembly. If the binary has been modified
to resist debugging then the Examinier probably will not be able to analyze the
code. Also the Examiner will not analyze live running code.

%prep
%setup -q -n %{name}-%{version}
%patch0 -p1 -b .hashes

%build
# empty build
chmod 644 utils/*

%install
mkdir -p %{buildroot}/%{_bindir}
mkdir -p %{buildroot}/%{_mandir}/man1/

sed -i -e 's@cp @cp -p @' Makefile  # Save timestamp

make install BIN=%{buildroot}%{_bindir}/ \
    MAN=%{buildroot}%{_mandir}/man1/ \
    SHARE=%{buildroot}%{_datadir}/%{name} INSTALL="install -p"

# Bogusly installed patch-suffixed file
rm %{buildroot}%{_datadir}/%{name}/os/linux/examiner_hashes.pl.hashes

%files
%doc docs/BUGS docs/CHANGELOG docs/README docs/TODO docs/TUTORIAL
%doc --no-dereference docs/COPYING
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*
%{_datadir}/%{name}/

%changelog
