# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define oname	ExMplayer

Name:		exmplayer
Version:	5.0.1
Release:	alt2_8
Summary:	MPlayer GUI with thumbnail seeking and 3D Video support
License:	GPLv2+
Group:		Video
Url:		http://exmplayer.sourceforge.net/
Source0:	https://github.com/rupeshs/ExMplayer/archive/v%{version}/%{name}-%{version}.tar.gz
Patch0:		exmplayer-3.8.0-segfault.patch
Patch1:		exmplayer-5.0.1-int3.patch
Patch2:		exmplayer-5.0.1-gcc7.patch

BuildRequires:	ccmake cmake ctest
BuildRequires:	ffmpeg ffplay ffprobe
BuildRequires:	ImageMagick-tools
BuildRequires:	libqt4-devel qt5-declarative-devel qt5-tools
BuildRequires:	libavcodec-devel libavdevice-devel libavfilter-devel libavformat-devel libavresample-devel libavutil-devel libpostproc-devel libswresample-devel libswscale-devel

Requires:	ffmpeg ffplay ffprobe
Requires:	mplayer mplayer-tools
Requires:	youtube-dl
Source44: import.info

%description
ExMplayer (Extended MPlayer) is a GUI front-end for MPlayer with flow view
and tool like media cutter. It can play audio, video, dvd files(.vob), vcd
files(.mpg,.dat) etc and supports network streaming. It supports subtitles,
subtitle decoding is done by using ass library. It can play any media formats
without any external codecs.


%prep
%setup -q -n %{oname}-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1


# wrong-file-end-of-line-encoding
sed -i 's/\r$//' Release_notes.txt README.md

%build
%add_optflags -Wno-error=return-type
%qmake_qt4 src/%{oname}.pro
%make_build

%install
%makeinstall_std

mkdir -p %{buildroot}%{_bindir}
install -m 0755 %{name} %{buildroot}%{_bindir}/%{name}

mkdir -p %{buildroot}%{_sysconfdir}/%{name}
install -m 0644 linux_build/fmts %{buildroot}%{_sysconfdir}/%{name}/fmts
install -m 0644 linux_build/sc_default.xml %{buildroot}%{_sysconfdir}/%{name}/sc_default.xml

mkdir -p %{buildroot}%{_datadir}/applications
install -m 0644 %{name}.desktop %{buildroot}%{_datadir}/applications/%{name}.desktop
install -m 0644 %{name}_enqueue.desktop %{buildroot}%{_datadir}/applications/%{name}_enqueue.desktop

mkdir -p %{buildroot}%{_datadir}/%{name}
ln -s %{_bindir}/ffmpeg %{buildroot}%{_datadir}/%{name}/ffmpeg

# install menu icons
for N in 16 32 48 64 128 256;
do
  convert debian/%{name}.png -resize ${N}x${N} $N.png;
  install -D -m 0644 $N.png %{buildroot}%{_iconsdir}/hicolor/${N}x${N}/apps/%{name}.png
done

%files
%doc README.md Release_notes.txt
%{_bindir}/%{name}
%{_datadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_datadir}/applications/%{name}_enqueue.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png
%config(noreplace) %{_sysconfdir}/%{name}/fmts
%config(noreplace) %{_sysconfdir}/%{name}/sc_default.xml


%changelog
