Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/diff /usr/bin/gs /usr/bin/pdftex pkgconfig(poppler) pkgconfig(poppler-glib)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           extractpdfmark
Version:        1.1.1
Release:        alt1_5
Summary:        Extract page mode and named destinations as PDFmark from PDF

License:        GPLv3+
URL:            https://github.com/trueroad/extractpdfmark/
Source0:        https://github.com/trueroad/extractpdfmark/releases/download/v%{version}/%{name}-%{version}.tar.gz

BuildRequires:  automake
BuildRequires:  gcc-c++
BuildRequires:  gettext-tools libasprintf-devel
BuildRequires:  libpoppler-cpp-devel
Source44: import.info

%description
When you create a PDF document using something like a TeX system you may include
many small PDF files in the main PDF file. It is common for each of the small
PDF files to use the same fonts.

If the small PDF files contain embedded font subsets, the TeX system includes
them as-is in the main PDF. As a result, several subsets of the same font are
embedded in the main PDF. It is not possible to remove the duplicates since they
are different subsets. This vastly increases the size of the main PDF file.

On the other hand, if the small PDF files contain embedded full font sets, the
TeX system also includes all of them in the main PDF. This time, the main PDF
contains duplicates of the same full sets of fonts. Therefore, Ghostscript can
remove the duplicates. This may considerably reduce the main PDF-file's size.

Finally, if the small PDF files contain some fonts that are not embedded, the
TeX system outputs the main PDF file with some fonts missing. In this case,
Ghostscript can embed the necessary fonts. It can significantly reduce the
required disk size.

Either way, when Ghostscript reads the main PDF produced by the TeX system and
outputs the final PDF it does not preserve PDF page-mode and named-destinations
etc. As a result, when you open the final PDF, it is not displayed correctly.
Also, remote PDF links will not work correctly.

This program is able to extract page mode and named destinations as PDFmark from
PDF. By using this you can get the small PDF files that have preserved them.

%prep
%setup -q



%build
%configure --with-poppler=cpp
%make_build


%install
%makeinstall_std
rm %{buildroot}%{_docdir}/%{name}/COPYING

%check
make check

%files
%{_mandir}/man1/extractpdfmark.1*
%{_bindir}/extractpdfmark

%doc --no-dereference COPYING

%doc NEWS README.*



%changelog
