Group: Sound
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ezstream
Version:        1.0.2
Release:        alt1_8
Summary:        Command line source client for Icecast media streaming servers
## Not installed files:
# aclocal.m4:               FSFULLR
# build-aux/compile:        GPLv2+ with Autoconf exception
# build-aux/config.guess:   GPLv3+ with Autoconf exception
# build-aux/config.rpath:   FSFULLR
# build-aux/config.sub:     GPLv3+ with Autoconf exception
# build-aux/depcomp:        GPLv2+ with Autoconf exception
# build-aux/install-sh:     MIT and Public Domain
# build-aux/ltmain.sh:      GPLv3+ and
#                           GPLv3+ with Libtool exception and
#                           GPLv2+ with Libtool exception
# build-aux/missing:        GPLv2+ with Autoconf exception
# build-aux/test-driver:    GPLv2+ with Autoconf exception
# compat/getopt.c:          MIT and BSD
# compat/reallocarray.c:    MIT
# configure:                GPLv2+ with Libtool exception and FSFUL
# doc/Makefile.in:          FSFULLR
# examples/Makefile.in:     FSFULLR
# INSTALL:                  FSFUL
# m4/attribute.m4:          MIT
# m4/ccflags.m4:            MIT
# m4/libshout.m4:           MIT
# m4/libtool.m4:            GPLv2+ with Libtool exception and FSFULLR and FSFUL
# m4/libxml2.m4:            MIT
# m4/ltoptions.m4:          FSFULLR
# m4/ltsugar.m4:            FSFULLR
# m4/ltversion.m4:          FSFULLR
# m4/Makefile.in:           FSFULLR
# m4/tree.m4:               MIT
# Makefile.in:              FSFULLR
# src/Makefile.in:          FSFULLR
# tests/Makefile.in:        FSFULLR
## Installed files:
# compat/strlcat.c:         MIT
# compat/strlcpy.c:         MIT
# compat/strtonum.c:        MIT
# COPYING:                  GPLv2
# doc/ezstream-cfgmigrate.1.in.in:  MIT
# doc/ezstream-file.sh.1*:  MIT
# doc/ezstream.1*:          GPLv2
# src/cfg.c:                MIT
# src/cfg.h:                MIT
# src/cfg_decoder.c:        MIT
# src/cfg_decoder.h:        MIT
# src/cfg_encoder.c:        MIT
# src/cfg_encoder.h:        MIT
# src/cfg_intake.c:         MIT
# src/cfg_intake.h:         MIT
# src/cfg_private.h:        MIT
# src/cfg_server.c:         MIT
# src/cfg_server.h:         MIT
# src/cfg_stream.c:         MIT
# src/cfg_stream.h:         MIT
# src/cfgfile_xml.c:        MIT
# src/cfgfile_xml.h:        MIT
# src/cmdline.c:            MIT
# src/cmdline.h:            MIT
# src/ezconfig0.c:          GPLv2
# src/ezconfig0.h:          GPLv2
# src/ezstream.c:           GPLv2
# src/ezstream.h:           MIT
# src/ezstream-cfgmigrate.c:    MIT
# src/ezstream-file.sh.in:  MIT
# src/log.c:                MIT
# src/log.h:                MIT
# src/mdata.c:              MIT
# src/mdata.h:              MIT
# src/playlist.c:           MIT
# src/playlist.h:           MIT
# src/stream.c:             MIT
# src/stream.h:             MIT
# src/util.c:               GPLv2
# src/util.h:               GPLv2
# src/xalloc.c:             MIT
# src/xalloc.h:             MIT
License:        GPLv2 and MIT
URL:            https://www.icecast.org/%{name}/
Source0:        https://downloads.xiph.org/releases/%{name}/%{name}-%{version}.tar.gz
# Link to distribution-wide certificate store, not upsreamable
Patch0:         ezstream-1.0.1-doc-Link-to-distribution-OpenSSL-certificate-bundle.patch
BuildRequires:  autoconf >= 2.61
BuildRequires:  automake >= 1.10
BuildRequires:  coreutils
BuildRequires:  gcc
# gettext-devel for AM_ICONV macro
BuildRequires:  gettext-tools libasprintf-devel
BuildRequires:  libtool
BuildRequires:  pkgconfig(check) >= 0.9.4
BuildRequires:  pkgconfig(libxml-2.0) >= 2
BuildRequires:  pkgconfig(shout) >= 2.2
BuildRequires:  pkgconfig(taglib_c) >= 1.4
Source44: import.info

%description
Ezstream is a command line source client for media streams, primarily for
streaming to Icecast servers.

It allows the creation of media streams based on input from files or standard
input that is piped through an optional external decoder and encoder. As every
part of this chain is highly configurable, ezstream can be useful in a large
number of streaming setups.

Supported media containers for streaming are MP3, Ogg, Theora, WebM, and
Matroska. Supported transport protocols are HTTP, ICY, and RoarAudio.
Metadata support is provided by TagLib library.

%prep
%setup -q
%patch0 -p1
# Regenerate a build script
autoreconf -fi
# Remove bundled code
rm compat/{getopt,reallocarray}.c
# Copy examples for a documention
mkdir __examples
cp -a examples __examples/examples
rm -f __examples/examples/Makefile*
chmod a-x __examples/examples/*

%build
%configure \
    --without-asan \
    --enable-largefile \
    --disable-maintainer-mode \
    --disable-rpath \
    --enable-shared \
    --disable-static
# --with-taglib actually inhibits the taglib support
%{make_build}

%check
make %{?_smp_mflags} check

%install
%{makeinstall_std}
rm -rf $RPM_BUILD_ROOT%{_docdir} $RPM_BUILD_ROOT%{_datadir}/examples

%files
%doc --no-dereference COPYING
%doc ChangeLog NEWS README.md __examples/examples
%{_bindir}/ezstream
%{_bindir}/ezstream-cfgmigrate
%{_bindir}/ezstream-file.sh
%{_mandir}/man1/ezstream.1*
%{_mandir}/man1/ezstream-cfgmigrate.1*
%{_mandir}/man1/ezstream-file.sh.1*

%changelog
