# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ libGLU-devel libSDL2_ttf-devel libfreetype-devel pkgconfig(CEGUI-0-IRRLICHT)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name fifechan
%define version 0.1.5
%define major     %{version}
%define libname   lib%{name}%{major}
%define develname lib%{name}-devel

Name:           fifechan
Version:        0.1.5
Release:        alt1_3
Summary:        Portable C++ GUI library for games using Allegro, SDL and OpenGL
Group:          System/Libraries
License:        LGPLv2+
URL:            https://fifengine.github.io/fifechan/
Source0:        https://github.com/fifengine/fifechan/archive/%{version}/%{name}-%{version}.tar.gz

BuildRequires:  liballegro-devel
BuildRequires:  ccmake cmake ctest
BuildRequires:  libirrlicht-devel
BuildRequires:  pkgconfig(gl)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_image)
Source44: import.info

%description
Fifechan is a lightweight cross platform GUI library written in C++
specifically designed for games. It has a small yet powerful built in set
of extendable GUI Widgets allowing users to create virtually unlimited
types of widgets. Fifechan supports rendering in SDL, OpenGL, or Allegro
out of the box or it can be adapted to use any rendering engine the user
requires. Events are pushed to Fifechan which allows users to use any input
library they wish or they could use the built in input handling through
either SDL input or Allegro input.

%package -n %{libname}
Summary:        Shared library for %{name}
Group:          System/Libraries
Provides:       %{name} = %{version}-%{release}

%description -n %{libname}
This package contains the library needed to run programs dynamically
linked with %{name}.

%package -n %{develname}
Summary:        Headers for developing programs that will use %{name}
Group:          Development/C++
Requires:       %{libname} = %{version}-%{release}
Provides:       %{name}-devel = %{version}-%{release}

%description -n %{develname}
This package contains the headers that programmers will need to develop
applications which will use %{name}.

%prep
%setup -q


iconv -f ISO-8859-1 -t UTF-8 AUTHORS > AUTHORS.new
touch -r AUTHORS AUTHORS.new
mv AUTHORS.new AUTHORS

%build
%{mageia_cmake}
%mageia_cmake_build

%install
%mageia_cmake_install

%files -n %{libname}
%doc AUTHORS CHANGELOG.md README.md
%{_libdir}/lib%{name}*.so.%{major}*

%files -n %{develname}
%{_includedir}/%{name}*
%{_libdir}/lib%{name}*.so


%changelog
