# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           fit-java
Version:        1.1
Release:        alt1_8
Summary:        Framework for Integrated Test (Java implementation)
License:        GPL
Group:          Development/Java
URL:            http://fit.c2.com/
Source0:        http://downloads.sourceforge.net/project/fit/fit-java/%{version}/fit-java-%{version}.zip
Patch0:         fit-java-1.1-javadoc.patch
BuildRequires:  ant
BuildRequires:  javapackages-tools
BuildRequires:  junit
BuildRequires:  java-devel-default /proc
BuildRequires:  xerces-j2
BuildRequires:  xml-commons-apis
Requires:       javapackages-tools
Requires:       java
BuildArch:      noarch
Source44: import.info

%description
Great software requires collaboration and communication.
Fit is a tool for enhancing collaboration in software
development. It's an invaluable way to collaborate on
complicated problems--and get them right--early in
development.

Fit allows customers, testers, and programmers to learn
what their software should do and what it does do. It
automatically compares customers' expectations to actual
results.

%package javadoc
Group:          Development/Java
Summary:        Javadoc for %{name}
BuildArch: noarch

%description javadoc
Fit is a framework for writing acceptance tests as
used in extreme programming (Java implementation).

This package contains javadoc for %{name}.

%prep
%setup -q -c %{name}-%{version}
%patch0

for j in $(find . -name "*.jar"); do
  mv $j $j.no
done

for c in $(find . -name "*.class"); do
  rm -rf $c
done


for i in `find -name "*.java"`
do
        native2ascii -encoding UTF8 $i $i
done

%build

cd source/imp/java
export CLASSPATH=$(build-classpath ant xerces-j2 xml-commons-apis junit):output/classes
ant jars javadoc

%install
mkdir -p %{buildroot}%{_javadir}

cd source/imp/java
install -pm 0644 output/jars/fit.jar %{buildroot}%{_javadir}/fit-%{version}.jar

(
  cd %{buildroot}%{_javadir}/
  for jar in *-%{version}*; do
    ln -sf ${jar} ${jar/-%{version}/}
  done
)

mkdir -p %{buildroot}%{_javadocdir}/fit-%{version}
cp -pr output/apidocs/* %{buildroot}%{_javadocdir}/fit-%{version}/
ln -sf fit-%{version} %{buildroot}%{_javadocdir}/fit

%files
%{_javadir}/fit-%{version}.jar
%{_javadir}/fit.jar

%files javadoc
%{_javadocdir}/fit-%{version}
%{_javadocdir}/fit



%changelog
