Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate fontconfig-devel libXcursor-devel libXext-devel libXfixes-devel libXft-devel libXinerama-devel libXrender-devel libjpeg-devel libpng-devel zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           flamp
Version:        2.2.05
Release:        alt1_6
Summary:        Amateur Multicast Protocol - file transfer program

License:        GPLv3+
URL:            http://www.w1hkj.com/
Source0:        http://www.w1hkj.com/files/%{name}/%{name}-%{version}.tar.gz
Patch0:         flamp-gcc11.patch

BuildRequires:  autoconf automake libtool
BuildRequires:  gcc gcc-c++
BuildRequires:  libfltk-devel >= 1.3.0
BuildRequires:  libX11-devel
BuildRequires:  desktop-file-utils

Provides:       bundled(xmlrpc)
Source44: import.info


%description
Flamp is a program for AMP or Amateur Multicast Protocol. An flamp session will
transmit one or more files with one or more iterations of the transmission.

Each file is broken into blocks, each of which has a check sum. The receiving
station saves the blocks that pass check sum. Successive transmissions will fill
in the missing blocks provided that the new blocks pass the check sum. After the
transmission sequence, the entire file is assembled and may be saved. a.'Fillsa.'
may be provided by retransmitting the entire file or by the sending station only
sending the missing blocks. Start by downloading the current version of flamp
from http://www.w1hkj.com/download.html. Install the software as you would any
of the NBEMS applications.


%prep
%setup -q
%patch0 -p1



%build
export CXXFLAGS="-std=c++14 $RPM_OPT_FLAGS"
%configure
%make_build


%install
%makeinstall_std


%check
desktop-file-validate %{buildroot}%{_datadir}/applications/%{name}.desktop


%files
%doc --no-dereference COPYING
%doc AUTHORS ChangeLog README
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.xpm


%changelog
