Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with pylirc
%bcond_without pulse

Summary: Simple Video for Linux radio card programs
Name:    fmtools
Version: 2.0.7
Release: alt1_22
License: GPLv2+
URL:     http://benpfaff.org/fmtools

Source0: http://benpfaff.org/fmtools/%{name}-%{version}.tar.gz
Source1: fmcontrol.tar.gz
Source2: http://benpfaff.org/fmtools/tkradio
Source3: http://benpfaff.org/fmtools/tkradio-mute
Source4: fmtools.desktop
Source5: radio.png
Source8: radio.gif
Source6: tkradio.py
Source7: fmlircrc
Patch0: fmcontrol-py3.patch
BuildRequires: autoconf automake
BuildRequires: gcc
BuildRequires: python3-devel
Source44: import.info

%description
This is a pair of hopefully useful control programs for Video for Linux
(v4l2) radio card drivers.  The focus is on control, so you may find these
programs a bit unfriendly.  Users are encouraged to investigate the source
and create wrappers or new programs based on this design.

fm      - a simple tuner
fmscan  - a simple band scanner

%package tkradio
Group: Sound
Summary:       Python/Tk wrapper for fmtools
BuildRequires: desktop-file-utils
Requires:      %{name} = %{version}
Requires:      python3
%{?with_pylirc:Requires: python3-module-lirc}
Requires:      vorbis-tools, alsa-utils amixer aplay
#Requires:      python3-module-tkinter
%if %{with pulse}
Requires:      pulseaudio-daemon pulseaudio-utils
BuildArch:     noarch
%endif

%description tkradio
This package provides a GUI for %{name}, with lirc support.
The stations are read from the same files used by fmcontrol,
and the lirc configuration file is in $HOME/.fmlircrc

The script fmcontrol.py saves one from remembering frequencies
and volumes when using the "fm" program from %{name}.
All that it does is to tune into a station specified by name, at the
frequency and volume specified in $HOME/.fmrc or $HOME/.radiostations,
or the volume given on the command line.

%prep
%setup -q -a1
%patch0 -p1 -b .py3

%build
autoreconf -vif
%configure
%make_build

%install
%makeinstall_std
install -pm 0755 %{SOURCE2} %{buildroot}%{_bindir}/tkradio.tcl
install -pm 0755 %{SOURCE3} %{buildroot}%{_bindir}/tkradio-mute.tcl
install -pm 0755 %{SOURCE6} %{buildroot}%{_bindir}/tkradio.py
install -pm 0755 fmcontrol/fmcontrol %{buildroot}%{_bindir}/fmcontrol.py
install -pm 0644 fmcontrol/README README.fmcontrol

# menu entry
desktop-file-install                                    \
        --vendor ""                                     \
        --dir %{buildroot}%{_datadir}/applications      \
        %{SOURCE4}

install -Dpm 0644 %{SOURCE5} %{buildroot}%{_datadir}/pixmaps/radio.png
install -Dpm 0644 %{SOURCE7} %{buildroot}%{_datadir}/%{name}/fmlircrc
install -Dpm 0644 %{SOURCE8} %{buildroot}%{_datadir}/%{name}/radio.gif

%files 
%doc README
%doc --no-dereference COPYING
%{_bindir}/fm
%{_bindir}/fmscan
%{_mandir}/man1/fm**

%files tkradio
%doc README.fmcontrol fmcontrol/dot.*
%{_bindir}/tkradio*
%{_bindir}/fmcontrol.py
%{_datadir}/applications/fmtools.desktop
%{_datadir}/pixmaps/radio.png
%{_datadir}/%{name}/fmlircrc
%{_datadir}/%{name}/radio.gif

%changelog
