Group: Office
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate /usr/bin/glib-gettextize libgio-devel pkgconfig(gthread-2.0) rpm-build-python3 texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          foxtrotgps
Version:       1.2.2
Release:       alt3_18
Summary:       GTK+ mapping and GPS application
License:       GPLv2
URL:           http://www.foxtrotgps.org
Source0:       http://www.foxtrotgps.org/releases/%{name}-%{version}.tar.xz
Patch0:        dialog10-fix.patch
Patch1:        gpsd-API-v9-fix.patch
Patch2:        gpsd-API-v10-fix.patch

BuildRequires: gcc
BuildRequires: bluez libbluez-devel
BuildRequires: libdbus-devel
BuildRequires: gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires: libglade-devel
BuildRequires: libcurl-devel
BuildRequires: libexif-devel
BuildRequires: libxml2-devel
BuildRequires: libsqlite3-devel
BuildRequires: gettext-tools
BuildRequires: desktop-file-utils
BuildRequires: intltool
BuildRequires: libgps-devel

Requires: gpsd gpsd-clients-console gpsd-helpers

# The following two package are only needed, if someone wants
# to geotag photos, which is an optional functionality. We 
# decided to include them, because then all functionality is
# available without manual package installation.
Requires: gpscorrelate
Requires: jhead
Source44: import.info

%description
FoxtrotGPS is an easy-to-use graphical tool that can be used
to track the position of a GPS receiver on a map in relation to
user-defined points of interest (POIs), a destination and waypoints,
and tracks loaded from files or internet routing-services.

FoxtrotGPS also allows internet-connected users to share their position
with other users and send messages.

By default it uses map data from the OpenStreetMap.org project; 
additionally a variety of other repositories can easily be added.

%prep
%setup -q
%patch0 -p1
%patch1 -p0
%patch2 -p0

%build
%configure
%make_build

%install
make install DESTDIR=%{buildroot}

sed -i 's/Lieu/Lieu;/' %{buildroot}/usr/share/applications/foxtrotgps.desktop
desktop-file-validate %{buildroot}/%{_datadir}/applications/%{name}.desktop
rm -rf %{buildroot}/usr/share/doc/%{name}/
rm -rf %{buildroot}/usr/share/info/dir

%find_lang %{name}

%files -f %{name}.lang
%doc --no-dereference COPYING
%doc AUTHORS HACKING NEWS
%doc contrib/README.osb2foxtrot

%{_bindir}/foxtrotgps
%{_bindir}/convert2gpx
%{_bindir}/convert2osm
%{_bindir}/gpx2osm
%{_bindir}/poi2osm
%{_bindir}/osb2foxtrot
%{_bindir}/georss2foxtrotgps-poi
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/foxtrotgps.png
%{_datadir}/pixmaps/foxtrotgps-*.png
%{_datadir}/GConf/gsettings/org.foxtrotgps.convert
%{_datadir}/glib-2.0/schemas/org.foxtrotgps.gschema.xml
%{_mandir}/man?/*
%{_infodir}/foxtrotgps.info.*
%{_datadir}/%{name}

%changelog
