%define fedora 28
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Features in Fedora/Free Electronic Lab
#   Supported targets: F-15, F-16 and rawhide

# FIXME: flex-static is not provided on EL-5, EL-6

#
## To download development trunk
#
# svn export -r 6006 http://svn.openmoko.org/trunk/eda/fped fped-0
# tar cjf ~/rpmbuild/SOURCES/fped-0.tar.bz2 fped-0

Name:           fped
Version:        0
Release:        alt1_0.20.r6006
Summary:        A footprint editor used by openmoko developers

Group:          Engineering
License:        GPLv2
URL:            http://openmoko.org
Source0:        %{name}-%{version}.tar.bz2

BuildRequires:  gcc
BuildRequires:  gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel libgtk+2-gir-devel
BuildRequires:  bison
BuildRequires:  flex
%if 0%{?fedora}
BuildRequires:  flex
%endif
BuildRequires:  transfig
BuildRequires:  netpbm
BuildRequires:  ImageMagick-tools
Source44: import.info


%description
fped is an editor that allows the interactive creation of footprints of
electronic components. Footprint definitions are stored in a text format
that resembles a programming language.

The language is constrained such that anything that can be expressed in
the textual definition also has a straightforward equivalent operation
that can be performed through the GUI.

%prep
%setup -q

# Tuning makefile for fedora packaging guidelines
sed -i \
  -e "s|/usr/local|%{_prefix}|g" \
  -e "s|install -m|install -pm|" \
  -e "s|CFLAGS = |CFLAGS = %{optflags} |g" Makefile

%build
# Make verbose
export V=1
make dep
make manual
%make_build


%install
install -d %{buildroot}%{_bindir}
make install DESTDIR=%{buildroot}

%check
make test


%files
%doc README TODO gui.html manual/ COPYING.GPLv2
%doc examples
%{_bindir}/%{name}


%changelog
