# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# empty-debuginfo-package
%define debug_package %{nil}

%define git_ver git20181122
%define ver_fpc 3.0.4

Summary: Widget set to develop cross-platform GUI software using fpc
Name: fpgui
Version: 1.5
Release: alt1_0.git201811221
License: LGPLv2 with static linking exception
Group: Development/Tools
Url: http://fpgui.sourceforge.net
Source0: https://sourceforge.net/projects/fpgui/files/fpGUI/1.4.1/%{name}_src_%{version}_%{git_ver}.tar.gz
# https://github.com/graemeg/fpGUI/issues/49
Patch0: %{name}-1.5-mga-hints-workaround.patch
Requires: fpc-compiler fpc-ide fpc-units-gfx fpc-utils
Requires: pkgconfig(x11)
Requires: pkgconfig(fontconfig)
Requires: pkgconfig(xft)
BuildRequires: fpc-compiler fpc-ide fpc-units-gfx fpc-utils
BuildRequires: gettext gettext-tools
Source44: import.info

%description
This is a widget set to quickly develop cross-platform GUI software using
the Free Pascal Compiler. It doesn't rely on large third party libraries -
which makes fpGUI applications easy to deploy.

%prep
%setup -q
%patch0 -p1
cp -rf ./prototypes/mdi/*.pas ./src/corelib/
sed -i -e "s|Agg2D;|fpg_mdi,Agg2D;|g" ./src/corelib/x11/fpgui_toolkit.pas

%build
pushd src
./build.sh
popd
# build languages for uidesigner's localization
pushd languages
for lang in `ls |grep "%{name}.*..po"|cut -d "." --fields=2|grep -v en`
do
msgfmt %{name}.$lang.po -o %{name}.$lang.mo
done
popd

%install
_unittgt=`fpc -iSP`-`fpc -iSO`
pushd lib/$_unittgt
mkdir -p %{buildroot}%{_libdir}/fpc/%{ver_fpc}/units/$_unittgt/%{name}
cp -f ./* %{buildroot}%{_libdir}/fpc/%{ver_fpc}/units/$_unittgt/%{name}/
popd
# install languages for uidesigner's localization
pushd languages
for lang in `ls |grep "%{name}.*..po"|cut -d "." --fields=2|grep -v en`
do
mkdir -p %{buildroot}%{_datadir}/locale/$lang/LC_MESSAGES
cp -f %{name}.$lang.mo %{buildroot}%{_datadir}/locale/$lang/LC_MESSAGES/%{name}.mo
done
popd
# install po files for localization other applications
mkdir -p %{buildroot}%{_datadir}/%{name}/languages
cp -f languages/*.po %{buildroot}%{_datadir}/%{name}/languages/

%find_lang %{name}

%files -f %{name}.lang
%doc *.txt languages/*.txt
%{_libdir}/fpc/*/units/*/%{name}
%{_datadir}/%{name}


%changelog
