Group: Archiving/Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:    freeze
Version: 2.5.0
Release: alt2_39
Summary: freeze/melt/fcat compression utilities

# Confirmed with upstream, see email text in Source1
License:   GPL+
# No one agrees on the canonical download site, everyone uses the same version
Source0:   http://www.ibiblio.org/pub/Linux/utils/compress/freeze-%{version}.tar.gz
Source1:   Freeze_license_email.txt
Patch0:    freeze-2.5.patch
Patch1:    freeze-2.5.0-printf.patch
Patch2:    freeze-2.5.0-deffile.patch

BuildRequires: gcc
Source44: import.info

%description
Freeze is an old file compressor and decompressor that is not in
common use anymore, but can be useful if the need ever arises to
dearchive files compressed with it.

%prep
%setup -q
cp -a %{SOURCE1} .
%patch0 -p1 -b .Makefile
%patch1 -p1 -b .printf
%patch2 -p1 -b .deffile

%build
# freeze is written in an old C dialect that uses implicit ints and
# implicit function declarations, and is not compatible with C99.
# Lower the language mode to C89.  This has to happen as part of CC,
# the CFLAGS change controlled by build_type_safety_c is insufficient.
%global build_type_safety_c 0

CC="$CC -std=gnu89"

chmod u+x configure
%configure
%make_build CFLAGS="$RPM_OPT_FLAGS -Dputc=putc"

%install
%makeinstall_std \
  DEST="%{buildroot}%{_bindir}" MANDEST="%{buildroot}%{_mandir}/man1/" \
  INSTALL_PROGRAM='install -D -p -m 0755' INSTALL_DATA='install -D -p -m 0644'

### Fix symlinks properly
for bin in fcat melt unfreeze; do
        ln -fs freeze %{buildroot}%{_bindir}/$bin
        rm -f %{buildroot}%{_mandir}/man1/$bin.1
        ln -fs freeze.1.gz %{buildroot}%{_mandir}/man1/$bin.1.gz
done

%files
%doc MANIFEST README Freeze_license_email.txt
%{_bindir}/*
%{_mandir}/man?/*

%changelog
