Group: File tools
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           fsniper
Version:        1.3.1
Release:        alt1_25
Summary:        A tool that monitors directories for new files and invokes scripts on them

License:        GPLv3+
URL:            https://github.com/l3ib/fsniper
Source0:        http://projects.l3ib.org/fsniper/files/fsniper-%{version}.tar.gz
Source1:        fsniper.service
Source2:        fsniper.conf
Source3:        fsniper.sysconfig

# Fix umask permissions - http://bugs.l3ib.org/index.php?do=details&task_id=21
Patch1:         fsniper-umask.patch
Patch2:         0001-Fix-an-error-message.patch
Patch3:         fsniper-wait3.patch

BuildRequires:  gcc
BuildRequires:  libmagic-devel
BuildRequires:  libpcre-devel libpcrecpp-devel

Requires(pre):    /usr/sbin/useradd /usr/sbin/groupadd

%define servicename fsniper.service
%define fsdir       %{_localstatedir}/lib/%{name}
Source44: import.info

%description
fsniper is a tool that monitors a given set of directories for new
files. Then, based on the new file's type or name, it invokes a script to
be run (any executable via the shell) on that file.  Common uses include
making a single drop directory for all things from a webbrowser etc, and
having semi-intelligent scripts figure out what to do with those files. You
write the scripts yourself.


%prep
%setup -q
%patch1 -p1 -b .umask
%patch2 -p1 -b .errmessage
%patch3 -p1 -b .wait3


%build
export CFLAGS="$CFLAGS -I/usr/include/pcre"
%configure
%make_build


%install
mkdir -p $RPM_BUILD_ROOT%{_unitdir}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig
mkdir -p $RPM_BUILD_ROOT%{fsdir}

make install DESTDIR=$RPM_BUILD_ROOT

install -pm 0755 %{SOURCE1} $RPM_BUILD_ROOT%{_unitdir}/%{servicename}
install -pm 0644 %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/fsniper.conf
install -pm 0644 %{SOURCE3} $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/fsniper
install -pm 0644 doc/doc.txt $RPM_BUILD_ROOT%{docdir}


%files
%{_bindir}/fsniper
%{_unitdir}/%{servicename}
%attr(-,%{name},%{name}) %dir %{fsdir}/
%config(noreplace) %{_sysconfdir}/fsniper.conf
%config(noreplace) %{_sysconfdir}/sysconfig/fsniper
%doc AUTHORS COPYING README
%doc doc/doc.txt doc/keyvalcfg.txt example.conf

%pre
if [ $1 = 1 ]; then
    getent group %{name} >/dev/null || groupadd -r %{name}
    getent passwd %{name} >/dev/null || \
           useradd -r -g %{name} -d %{_localstatedir}/lib/%{name} -s /sbin/nologin \
           -c "%{name} user" %{name}
    exit 0
fi

%post
if [ $1 -eq 1 ] ; then 
    # Initial installation 
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi

%preun
if [ $1 -eq 0 ] ; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable %{servicename} > /dev/null 2>&1 || :
    /bin/systemctl stop %{servicename} > /dev/null 2>&1 || :
fi

%postun
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then
    # Package upgrade, not uninstall
    /bin/systemctl try-restart %{servicename} >/dev/null 2>&1 || :
fi

%changelog
