Group: Office
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:     fuelmanager
Version:  0.5.1
Release:  alt1_6
Summary:  Manage fuel mileage

License:  GPLv3+

URL:     https://gitlab.com/kc8hfi/fuelmanager
Source0: https://gitlab.com/kc8hfi/%{name}/-/archive/%{version}/%{name}-%{version}.tar.bz2

BuildRequires: qt5-base-devel
BuildRequires: desktop-file-utils

Requires: icon-theme-hicolor
Requires: qt4-assistant qt5-assistant
Source44: import.info

%description
Application that keeps track of four things, miles, gallons, cost, and 
the date of each fill-up.  It generates monthly and yearly summaries of 
miles driven, cost of fuel,how many gallons, and fuel mileage.

%prep
%setup -q

%build

%qmake_qt5 %{name}.pro PREFIX=%{_prefix}
%make_build

%install

make install INSTALL_ROOT=%{buildroot} 

desktop-file-install --dir=%{buildroot}%{_datadir}/applications %{name}.desktop

for s in 16 22 24 32 48 256; do
     mkdir -p %{buildroot}%{_datadir}/icons/hicolor/${s}x${s}/apps
     cp icons/${s}x${s}/%{name}.png %{buildroot}%{_datadir}/icons/hicolor/${s}x${s}/apps/%{name}.png
done

mkdir -p %{buildroot}%{_datadir}/icons/hicolor/scalable/apps/
cp %{name}.svg %{buildroot}%{_datadir}/icons/hicolor/scalable/apps/

# install the AppData file
mkdir -p %{buildroot}%{_datadir}/appdata
cp fuelmanager.appdata.xml %{buildroot}%{_datadir}/appdata/


%files
%doc COPYING
%doc documentation/fuelmanager.qhc
%{_bindir}/%{name}
%{_datadir}/appdata/*.*
%{_datadir}/applications/*.*
%{_datadir}/icons/hicolor/scalable/apps/*
%{_datadir}/icons/hicolor/16x16/apps/*
%{_datadir}/icons/hicolor/22x22/apps/*
%{_datadir}/icons/hicolor/24x24/apps/*
%{_datadir}/icons/hicolor/256x256/apps/*
%{_datadir}/icons/hicolor/32x32/apps/*
%{_datadir}/icons/hicolor/48x48/apps/*


%changelog
