Group: System/Servers
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Net/RawIP.pm) perl(Test.pm) perl(Test/More.pm) perl-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global fwsnortlogdir /var/log/fwsnort

Summary: Translates Snort rules into equivalent iptables rules
Name: fwsnort
Version: 1.6.5
Release: alt2_25
License: GPLv2+
Url: http://www.cipherdyne.org/%{name}/
Source0: http://www.cipherdyne.org/%{name}/download/%{name}-%{version}.tar.gz
Source1: logrotate.fwsnort
BuildArch: noarch 
BuildRequires: rpm-build-perl
Requires: iptables
Requires: perl(NetAddr/IP.pm)
Requires: perl(IPTables/Parse.pm) 
Requires: logrotate 
Requires: wget
Source44: import.info

%description
fwsnort translates Snort rules into equivalent iptables rules and generates
a Bourne shell script that implements the resulting iptables commands.

In addition, fwsnort (optionally) uses the IPTables::Parse module to parse the
iptables ruleset on the machine to determine which Snort rules are applicable
to the specific iptables policy.

fwsnort is able to translate approximately 60% of all rules from the
Snort-2.3.3 IDS into equivalent iptables rules. 

%prep
%setup -q 
mv deps/snort_rules/VERSION SNORT-RULES-VERSION
cp -p %SOURCE1 .

%build

%install
### log directory
mkdir -p $RPM_BUILD_ROOT%{fwsnortlogdir}

### fwsnort config
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/%{name}

mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man8
mkdir -p $RPM_BUILD_ROOT%{_sbindir}

install -m 755 fwsnort $RPM_BUILD_ROOT%{_sbindir}/
install -m 644 fwsnort.conf $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/
install -m 644 fwsnort.8 $RPM_BUILD_ROOT%{_mandir}/man8/

### install snort rules files
cp -r deps/snort_rules $RPM_BUILD_ROOT%{_sysconfdir}/%{name}

mkdir -p $RPM_BUILD_ROOT/etc/logrotate.d
install -p -m 644  logrotate.fwsnort $RPM_BUILD_ROOT/etc/logrotate.d/%{name}

%files
%doc LICENSE VERSION README CREDITS TODO SNORT-RULES-VERSION
%dir %{fwsnortlogdir}
%{_sbindir}/*
%{_mandir}/man8/*

%dir %{_sysconfdir}/%{name}
%config(noreplace) %{_sysconfdir}/%{name}/fwsnort.conf

%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}

%dir %{_sysconfdir}/%{name}/snort_rules
%config(noreplace) %{_sysconfdir}/%{name}/snort_rules/*

%changelog
