Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/gosh TestU01-devel gcc-c++ libbsd-devel libcrypt-devel libgperftools-devel texinfo
# END SourceDeps(oneline)
Requires(pre): /proc
BuildRequires: /proc
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           gauche
Version:        0.9.9
Release:        alt2_3
Summary:        Scheme script interpreter with multibyte character handling

%if 0%{?rhel}
%endif
License:        BSD
URL:            http://practical-scheme.net/gauche/index.html
Source:         http://download.sourceforge.net/gauche/Gauche-%{version}.tgz

%if 0%{?el5}
%endif

BuildRequires:  gcc
BuildRequires:  libgdbm-devel
BuildRequires:  openssl
BuildRequires:  makeinfo
Requires:       slib

%define main_version 0.97
Source44: import.info

%description
Gauche is a Scheme interpreter conforming Revised^5 Report on
Algorithmic Language Scheme.  It is designed for rapid development of
daily tools like system management and text processing.  It can handle
multibyte character strings natively.


%package devel
Group: Development/Other
Summary:        Development files for Gauche
Requires:       %{name} = %{version}-%{release}

%description devel
Development files for Gauche.


%prep
%setup -q -n Gauche-%{version}

%build
%configure --with-rpath=no --enable-threads=pthreads --enable-multibyte=utf-8 --with-slib=%{_datadir}/slib
LD_LIBRARY_PATH=`pwd`/src make \
%ifarch %{ix86}
  OPTFLAGS="-fomit-frame-pointer"
%else
  %{nil}
%endif


%install
%if 0%{?el5}
rm -fr $RPM_BUILD_ROOT
%endif
LD_LIBRARY_PATH=`pwd`/src make DESTDIR=$RPM_BUILD_ROOT install-pkg
LD_LIBRARY_PATH=`pwd`/src make DESTDIR=$RPM_BUILD_ROOT install-doc

# correct permissions
chmod -R u+w $RPM_BUILD_ROOT
chmod 0644 examples/grep.scm
chmod 0644 ext/template.*

# remove static lib
rm -f $RPM_BUILD_ROOT%{_libdir}/libgauche-static-%{main_version}.a

# remove japanese doc
rm -f $RPM_BUILD_ROOT%{_infodir}/gauche-refj.*

# this things go into the doc of the devel package
rm -f $RPM_BUILD_ROOT%{_datadir}/gauche/%{version}/template*
rm -f $RPM_BUILD_ROOT%{_datadir}/gauche/%{version}/aclocal*

# make .c files readable for debuginfo
find -name '*.c' | xargs chmod 0644
for rpm404_ghost in %{_datadir}/gauche-%{main_version}/%{version}/lib/slibcat
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done



%check
cd src; LD_LIBRARY_PATH=$RPM_BUILD_ROOT%{_libdir} make test

%post
/usr/bin/gosh -u slib -e "(require 'logical)" -e "(exit 0)" > /dev/null 2>&1 || echo


%files
%doc --no-dereference COPYING
%doc ChangeLog AUTHORS VERSION examples
%{_bindir}/gauche-cesconv
%{_bindir}/gauche-install
%{_bindir}/gauche-package
%{_bindir}/gosh
%{_libdir}/libgauche-%{main_version}.so.*
%{_libdir}/gauche-%{main_version}
%{_infodir}/*
%{_mandir}/man*/gosh.*
%{_mandir}/man*/gauche-cesconv.*
%{_mandir}/man*/gauche-install.*
%{_mandir}/man*/gauche-package.*
%{_datadir}/gauche-%{main_version}
%exclude %{_datadir}/gauche-%{main_version}/%{version}/template*
%exclude %{_libdir}/gauche-%{main_version}/%{version}/include
%ghost %{_datadir}/gauche-%{main_version}/%{version}/lib/slibcat


%files devel
%doc ext/template.*
%{_bindir}/gauche-config
%{_libdir}/libgauche-%{main_version}.so
%{_libdir}/gauche-%{main_version}/%{version}/include
%{_datadir}/gauche-%{main_version}/%{version}/template*
%{_datadir}/aclocal/gauche.m4
%{_mandir}/man*/gauche-config*


%changelog
