Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/gauche-cesconv /usr/bin/gauche-install /usr/bin/gauche-package /usr/bin/gosh imake libXt-devel libglvnd-devel texinfo xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname gauche-gl
%global gauche_main_version 0.97


Name:           gauche-gl
Version:        0.6
Release:        alt3_18
Summary:        OpenGL binding for Gauche

License:        BSD
URL:            http://practical-scheme.net/
Source:         http://practical-scheme.net/vault/Gauche-gl-%{version}.tgz

BuildRequires:  gcc
BuildRequires:  gauche-devel
BuildRequires:  libfreeglut-devel
BuildRequires:  libSM-devel
BuildRequires:  libXext-devel
BuildRequires:  libXi-devel
BuildRequires:  libXmu-devel
BuildRequires:  makeinfo
Source44: import.info


%description
OpenGL binding for Gauche.


%package devel
Group: Development/Other
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description devel
Development files for %{name}.


%prep
%setup -q -n Gauche-gl-%{version}

# add RPM opt flags
sed -i 's/@X_CFLAGS@/@X_CFLAGS@ @CFLAGS@/g' src/Makefile.in


%build
%configure
%make_build


%install
%if 0%{?el5}
%endif
make install DESTDIR=$RPM_BUILD_ROOT

# no japanese info docs
rm -f $RPM_BUILD_ROOT%{_infodir}/gauche-gl-refj.*

# make .so files executable
find $RPM_BUILD_ROOT -name '*.so' -exec chmod 0755 '{}' ';'

# include file not necessary
rm -rf $RPM_BUILD_ROOT%{_libdir}/gauche/%{gauche_version}*/include

# correct end-of-line-encoding
sed -i 's/\r//' examples/slbook/ogl2particle/* examples/slbook/ogl2brick/*

# these are not necessary
rm -f examples/glbook/run
rm -f examples/slbook/ogl2particle/run.sh

# set read permissions for debuginfo package
find . -print0 | xargs -0 chmod a+r


%check
make check

%files
%doc examples
%doc --no-dereference COPYING
%{_libdir}/gauche-%{gauche_main_version}/site/*/libgauche-*.so
%{_datadir}/gauche-%{gauche_main_version}/site/lib/.packages/Gauche-gl.gpd
%{_datadir}/gauche-%{gauche_main_version}/site/lib/gl.scm
%{_datadir}/gauche-%{gauche_main_version}/site/lib/gl
%{_infodir}/gauche-gl-refe.*


%files devel
%{_libdir}/gauche-%{gauche_main_version}/site/include/gauche/math3d.h


%changelog
