# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: boost-devel python-devel rpm-build-python
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           gearbox
Version:        10.11
Release:        alt1_18
Summary:        A collection of usable peer-reviewed robotics-related libraries

Group:          Development/Other
License:        LGPLv2+ and GPLv2+
URL:            http://gearbox.sourceforge.net
Source0:        http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
# Moves the library installation path from libdir/name to libdir
Patch0:         gearbox-9.11.fixinstallpaths.patch
# Fixes DSO-related link errors.  Not yet submitted upstream
Patch1:         gearbox-9.11.fixdso.patch
# Fix build errors with gcc-4.7
Patch2:         gearbox-9.11.gcc47.patch
# Mark any 64-bit architecture as such
Patch3:         gearbox-64bit.patch



BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  ctest cmake
BuildRequires:  doxygen
BuildRequires:  graphviz libgraphviz
Source44: import.info


%description
Gearbox provides a collection of usable peer-reviewed robotics-related
libraries. Gearbox is not an integration framework. It provides a set
of implementations, without insisting on a standard API, for use by
any number of existing frameworks.  Gearbox includes cross-platform
libraries to communicate over TCP, UDP, and serial, and implements the
communication protocols of many popular sensors.


%package devel
Summary: Header files and libraries for %{name}
Group: Development/Other
Requires: %{name} = %{version}-%{release}
Requires: ctest cmake
%description devel
Contains the header files and libraries for %{name}. 
If you like to develop programs using %{name},
you will need to install %{name}-devel.


%prep
%setup -q
# Moves shared libraries from libdir/gearbox to libdir, as per FHS standards
%patch0 -p1 -b .fixinstallpaths
%patch1 -p1 -b .fixdso
%patch2 -p0 -b .gcc48
%patch3 -p1 -b .64bit
%build
%{fedora_cmake} \
  -DENABLE_LIB_FLEXIPORT=OFF \
  -DENABLE_LIB_BASICEXAMPLE=OFF \
  -DENABLE_LIB_GBXUTILACFR=ON \
  -DENABLE_LIB_GBXGARMINACFR=ON \
  -DENABLE_LIB_GBXSERIALACFR=ON \
  -DHOKUYO_AIST_BUILD_BINDINGS=OFF \
  -DGBX_BUILD_TESTS=ON \
  -DCMAKE_SKIP_RPATH:BOOL=ON\
%ifarch ppc64 
 -DENABLE_LIB_GBXSICKACFR=OFF\
%else
 -DENABLE_LIB_GBXSICKACFR=ON\
%endif
.

make VERBOSE=1
pushd doc
doxygen doxyfile
popd

%install
make install DESTDIR=$RPM_BUILD_ROOT

# Remove the examples that gearbox installs.  If needed
# they can be built from source contained in the datadir
rm $RPM_BUILD_ROOT%{_bindir}/*

%files
%doc LICENSE
%{_libdir}/*.so.*

%files devel
%doc doc/html
%doc doc/images
%{_libdir}/*.so
%{_libdir}/%{name}
%{_includedir}/%{name}
%{_libdir}/pkgconfig/*.pc
%{_datadir}/%{name}



%changelog
