# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ pkgconfig(x11) pkgconfig(xext) pkgconfig(xi) python3-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define		_major		1
%define		_name		geis
%define		libname		lib%{_name}%{_major}
%define		devname		lib%{_name}-devel

Name:		%_name
Version:	2.2.17
Release:	alt5_12
License:	GPLv3 and LGPLv3
Summary:	Gesture Engine Interface and Support Interface
Group:		System/Libraries
Url:		https://launchpad.net/geis
Source:		https://launchpad.net/%{name}/trunk/%{version}/+download/%{name}-%{version}.tar.xz
Patch1:		%{name}-2.2.14-configureac.patch
Patch2:		geis-2.2.17-gcc7.patch

BuildRequires:	pkgconfig(grail)
BuildRequires:	pkgconfig(frame)
BuildRequires:	pkgconfig(dbus-1)
BuildRequires:	pkgconfig(python3)
BuildRequires:	pkgconfig(xcb)
BuildRequires:	pkgconfig(check)
BuildRequires:	pkgconfig(xorg-server)
Source44: import.info

%description
GEIS is a library for applications and toolkit programmers
which provides a consistent platform independent interface
for any system-wide input gesture recognition mechanism.

%files
%doc README COPYING
%doc doc/Doxyfile doc/geisspec-1.0.asc doc/geisspec-docbook.xml
%{_bindir}/geistest
%{_mandir}/man1/geis*

#------------------------------------------------

%package -n %libname
Summary:        Gesture Engine Interface and Support Library Package
Group:          System/Libraries
Requires:       %{name} = %{version}-%{release}

%description -n %libname
This package contains the library needed to run programs
dynamically linked with geis.

%files -n %libname
%{_libdir}/libgeis.so.%{_major}
%{_libdir}/libgeis.so.%{_major}.*

#------------------------------------------------

%package -n %devname
Summary:        Gesture Engine Interface and Support Development Package
Group:          Development/C
Requires:       %{libname} = %{version}-%{release}
Requires:	pkgconfig(python3)
Provides:       %{name}-devel = %{version}-%{release}

%description -n %devname
This package provides headers files for geis development.

%files -n %devname
%dir %{_includedir}/%{name}
%{_includedir}/%{name}/geis.h
%{_includedir}/%{name}/geisimpl.h
%{_libdir}/pkgconfig/libgeis.pc
%{_libdir}/libgeis.so

#------------------------------------------------

%package -n python3-module-geis
Summary:	GEIS python 3 bindings
Group:		Development/Python
Requires:	%{name} = %{version}-%{release}
%{?python_provide:%python_provide python3-%{name}}

%description -n python3-module-geis
GEIS python 3 bindings.

%files -n python3-module-geis
%{_bindir}/pygeis
%dir %{python3_sitelibdir_noarch}/%{name}
%{python3_sitelibdir_noarch}/%{name}/*.py
%{python3_sitelibdir_noarch}/%{name}/__pycache__/
%{python3_sitelibdir}/_geis_bindings.so
%{_mandir}/man1/pygeis*

#------------------------------------------------

%package -n %{name}view
Summary:	GEIS View
Group:		System/Libraries
Requires:	python3-module-geis = %{version}-%{release}

%description -n %{name}view
GEIS View.

%files -n %{name}view
%{_bindir}/%{name}view
%{_datadir}/applications/geisview.desktop
%dir %{_datadir}/geisview
%{_datadir}/geisview/*.ui
%{_datadir}/pixmaps/geisview32x32.xpm
%dir %{python3_sitelibdir_noarch}/%{name}view
%{python3_sitelibdir_noarch}/%{name}view/*.py
%{python3_sitelibdir_noarch}/%{name}view/__pycache__/

#------------------------------------------------

%prep
%setup -q
%patch1 -p1
%patch2 -p1


%build
autoreconf -fi
automake --add-missing
%configure --disable-static
%make_build LIBS+="-lframe"

%install
%makeinstall_std

find %{buildroot} -name "*.la" -delete


%changelog
