Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install libglvnd-devel libgtk+2-devel libpng-devel zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           geomorph
Version:        0.62
Release:        alt2_21
Summary:        A height field editor for Linux
License:        GPL-2.0-only
URL:            http://geomorph.sourceforge.net
Source0:        http://sourceforge.net/projects/geomorph/files/geomorph/%{version}/%{name}-%{version}.tar.gz
Source1:        geomorph.desktop
Source2:        geomorph.appdata.xml
Source3:        geomorph.png
Patch0:         geomorph-format-security.patch
Patch1:         geomorph-array-bounds.patch
Patch2:         geomorph-glxbadcontext.patch
Patch3:         geomorph-gnusource.patch
Patch4:         geomorph-x_alloc.patch
Patch5:         geomorph-missing-string-headers.patch
Patch6:         geomorph-missing-custom-headers.patch
Patch7:         geomorph-define-get_current_dir_name-function.patch
Patch8:         geomorph-explicit-braces.patch
Patch9:         geomorph-int-to-pointer-cast.patch
Patch10:        geomorph-uninitialized-values.patch
Patch11:        geomorph-return-functions.patch
Patch12:        geomorph-printf-format.patch
Patch13:        geomorph-pointer-to-int-cast.patch
Patch14:        geomorph-pointer-sign.patch
Patch15:        geomorph-remove-gettext-at-compile-time.patch
Patch16:        geomorph-arg-not-used.patch
Patch17:        geomorph-incompatible-pointer-types.patch
Patch18:        geomorph-no-common.patch
#Patch20:        geomorph-update-autotools.patch

BuildRequires:  gcc
BuildRequires:  libgtkglext-devel
BuildRequires:  libGLU-devel
BuildRequires:  desktop-file-utils
BuildRequires:  libappstream-glib libappstream-glib-gir
#BuildRequires:  /usr/bin/autoreconf
#BuildRequires:  gettext-devel
#BuildRequires:  automake
Requires:       povray
Source44: import.info

%description
Geomorph is a height field generator and editor for the Linux operating system.
A height field is a kind of topographic map.  It is a 2D projection of a 
3D landscape.
Geomorph generates square images and shows a 3D preview of the resulting
landscape.  The resulting 2D image can be processed with a tool like Povray
for rendering the landscape.

%prep
%setup -qn %{name}-%{version}
%patch0 -p1 -b .format-security
%patch1 -p1 -b .array-bounds
%patch2 -p1 -b .glxbadcontext
%patch3 -p1 -b .gnusource
%patch4 -p1 -b .x_alloc
%patch5 -p1 -b .missing-string-headers
%patch6 -p1 -b .missing-custom-headers
%patch7 -p1 -b .define-get_current_dir_name-function
%patch8 -p1 -b .explicit-braces
%patch9 -p1 -b .int-to-pointer-cast
%patch10 -p1 -b .uninitialized-values
%patch11 -p1 -b .return-functions
%patch12 -p1 -b .printf-format
%patch13 -p1 -b .pointer-to-int-cast
%patch14 -p1 -b .pointer-sign
%patch15 -p1 -b .remove-gettext-at-compile-time
%patch16 -p1 -b .arg-not-used
%patch17 -p1 -b .incompatible-pointer-types
%patch18 -p1 -b .no-common.patch
#%patch20 -p1 -b .update-autotools
#autoreconf -vfi

# to avoid rpmlint warnings
# Remove exe bit from pixmaps
find . -name \*.xpm -exec chmod -x {} \;
# Switch to UTF-8
for file in LISEZMOI AFAIRE FAQ-fr
do
    iconv -f ISO-8859-1 -t UTF-8 $file > $file.utf8
    touch -r $file $file.utf8
    mv -f $file.utf8 $file
done
# Tarball contains an already compiled app.
# Remove and recompile it.
rm -f scenes/colmap

# Remove Hardcoded path
for file in install-step1-dir install-step2-rcfile install-step3-menu \
    install-step4-desktop install-user src/app/app.c src/app/main.c
do
    sed -i -e '/^VERSION/ s#=.*#=%{version}#g' \
        -e 's#/usr/local/share/geomorph#%{_datadir}/geomorph#g' \
        $file
done

%build
%configure \
    --disable-rpath

pushd scenes
gcc ${RPM_OPT_FLAGS} -Wl,-z,relro,-z,now -o colmap colmap.c
popd
%make_build

%install
make install DESTDIR="%{buildroot}"
%find_lang %{name}
mv %{buildroot}%{_datadir}/geomorph/%{version}/scenes/colmap %{buildroot}%{_bindir}/
rm -f %{buildroot}%{_datadir}/geomorph/%{version}/scenes/colmap.c
# Create directories
mkdir -p %{buildroot}%{_datadir}/icons
mkdir -p %{buildroot}%{_datadir}/applications
mkdir -p %{buildroot}%{_datadir}/appdata
# Copy new desktop file
desktop-file-install --dir=%{buildroot}%{_datadir}/applications %{SOURCE1}
# Copy icon file
cp %{SOURCE3} %{buildroot}%{_datadir}/icons
cp GeoMorph.xpm %{buildroot}%{_datadir}/icons
# Copy appdata
cp %{SOURCE2} %{buildroot}%{_datadir}/appdata

%check
appstream-util validate-relax --nonet %{buildroot}/%{_datadir}/appdata/*.appdata.xml

%files -f %{name}.lang
%doc ABOUT-NLS AFAIRE AUTHORS ChangeLog FAQ FAQ-fr LISEZMOI NEWS README TODO geomorphrc_de geomorphrc_en geomorphrc_fr
%{_bindir}/geomorph
%{_bindir}/colmap
%{_datadir}/geomorph
%{_datadir}/applications/geomorph.desktop
%{_datadir}/icons/geomorph.png
%{_datadir}/icons/GeoMorph.xpm
%{_datadir}/appdata/geomorph.appdata.xml

%changelog
