# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name gimp-plugin-astronomy
%bcond_with	gimp3

%define         moname        %{name}
%define		abi_version   %{?with_gimp3:2.99}%{?!with_gimp3:2.0}
%define         plugindir     %{_libdir}/gimp/%{abi_version}/plug-ins
%define         scriptdir     %{_datadir}/gimp/%{abi_version}/scripts

Name:           gimp-plugin-astronomy
Version:        0.11
Release:        alt1_2
Summary:        Astronomy plugins for the GIMP graphic editor
License:        GPLv2+
Group:          Graphics

URL:            https://github.com/JoesCat/gimp-plugin-astronomy
Source0:        https://github.com/JoesCat/gimp-plugin-astronomy/releases/download/%{version}/gimp-plugin-astronomy-%{version}.tar.bz2

BuildRequires:  gettext-tools libasprintf-devel
%if %{with gimp3}
BuildRequires:  pkgconfig(gimp-3.0)
BuildRequires:  pkgconfig(gtk+-3.0)
%else
BuildRequires:  pkgconfig(gimp-2.0)
BuildRequires:  pkgconfig(gtk+-2.0)
%endif
BuildRequires:  pkgconfig(fftw3)
BuildRequires:  pkgconfig(gsl)

%if %{with gimp3}
Requires:	gimp3 >= 2.99
%else
Requires:       gimp >= 2.6.0
%endif
Source44: import.info

%description
Gimp Astronomy is a set of plug-ins for the Gimp graphic editor
intended for astronomical image processing. They support various basic
and more advanced tasks such as aligning and stacking images with
arithmetic, geometric, median, or sigma mean, removing dark frames and
dividing by a flat field. Some plug-gins are designed for creating
synthetic stars distribution or synthetic galaxy images.


%prep
%setup -q


%if %{with gimp3}
# build for gimp-3.0
sed -i \
  -e 's/gimp-2.0/gimp-3.0/g' \
  -e 's/gimpui-2.0/gimpui-3.0/g' \
  -e 's/gimptool-2.0/gimptool-2.99/g' \
  configure.ac
%endif

# make autoreconf happy
sed -i \
  -e 's/AM_GNU_GETTEXT_VERSION\(([*.*]*)\)/AM_GNU_GETTEXT_REQUIRE_VERSION\1/' \
  -e 's/AM_GNU_GETTEXT_VERSION$/AM_GNU_GETTEXT_REQUIRE_VERSION([0.19.1])/' \
  configure.ac

%build
autoreconf -fi
export LIBS="-lm"
%configure \
    CPPFLAGS=-D_XOPEN_SOURCE=700
%make_build


%install
%makeinstall_std INSTALLDIR="%{buildroot}/%{plugindir}" \
      LOCALEDIR="%{buildroot}/%{_datadir}/locale"
%find_lang %{moname}


%files -f %{moname}.lang
%doc --no-dereference COPYING
%doc %{_docdir}/%{name}/documentation.*
%doc README AUTHORS
%{scriptdir}/*.scm
%{plugindir}/astronomy-*


%changelog
