# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define debug_package %{nil}
%define         srcname       separate+
%define         moname        gimp20-separate
%define         plugindir     %{_libdir}/gimp/2.0/plug-ins
%define __python %{__python3}


Name:           gimp-plugin-separate
Version:        0.5.8
Release:        alt1_13
Summary:        CYMK plugins for the GIMP graphic editor
License:        GPLv2+
Group:          Graphics

# This URL is defunct
URL:            https://cue.yellowmagic.info/softwares/separate-plus/index.html
Source0:        https://sourceforge.jp/projects/separate-plus/downloads/47873/%{srcname}-%{version}.zip
Patch0:         lcms2.patch

BuildRequires:  pkgconfig(gimp-2.0)
BuildRequires:  pkgconfig(gtk+-2.0)
BuildRequires:  pkgconfig(lcms2)
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  pkgconfig(libtiff-4)
Requires:       gimp >= 2.8.0

Provides:       %{srcname} = %{version}
Source44: import.info

%description
Separate+ is a project and plug-ins package aimed mainly for
complementing color management functionality of GIMP and for assisting
publication (Web, printing etc.) activities by utilizing open source
software. This package includes three plug-ins: a plug-in for RGB to
CMYK conversion, saving and soft-proofing; a plug-in for RGB to RGB
conversion and profile management, and finally a plug-in for importing
CMYK TIFF files.


%prep
%setup -q  -n %{srcname}-%{version}
%patch0 -p1


%build
%make_build CM="-DENABLE_COLOR_MANAGEMENT %{optflags}" \
            LDFLAGS="" TIFF_LIB="-ltiff" JPEG_LIB="-ljpeg -lm"

%install
%makeinstall_std INSTALLDIR="%{buildroot}%{plugindir}" \
              LOCALEDIR="%{buildroot}%{_datadir}/locale"

%find_lang %{moname}

%files -f %{moname}.lang
%doc README README_ICC_COLORSPACE
%{plugindir}/separate
%{plugindir}/separate_import
%{plugindir}/icc_colorspace


%changelog
