Group: Development/Tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commit 55c5c285558c410bb35ebf421245d320ab9ee9fa
%global shortcommit %(c=%{commit}; echo ${c:0:7})
%global checkoutdate 20181107
%global checkout %{checkoutdate}git%{shortcommit}

Name:       gitstats
Version:    0
Release:    alt2_0.26.%{checkout}
Summary:    Generates statistics based on GIT repository activity

# All code and content other than sortable.js is available under the GPLv2
# and GPLv3 licenses. The sortable.js file is available under the MIT license.
License:    GPLv2 and GPLv3 and MIT
URL:        http://%{name}.sourceforge.net
Source0:    https://github.com/hoxu/%{name}/archive/%{commit}/%{name}-%{commit}.tar.gz
Patch0:     %{name}-%{version}-gitstats.patch
BuildArch:  noarch

BuildRequires: /usr/bin/pod2man
Requires:   python3
Requires:   gnuplot-qt >= 4.0.0
Requires:   git >= 1.5.2.4
Source44: import.info

%description

GitStats is a statistics generator for git (a distributed revision control
system) repositories. It examines the repository and produces some interesting
statistics from the history of it. Currently HTML is the only output format.

%prep
%setup -qn %{name}-%{commit}
%patch0

%build
# Use pod2man directly instead of 'make man' as Makefile task expects to be
# running from a git clone (and generates the --release value based on this
# rather than the tarball.
pod2man --center "User Commands" -r "%{name}-%{version}-%{release}" doc/%{name}.pod doc/%{name}.1
gzip doc/%{name}.1

%install
make install PREFIX=%{buildroot}%{_prefix}

mkdir -p %{buildroot}%{_docdir}/%{name}
mkdir -p %{buildroot}%{_mandir}/man1/
install -p -m 0644 $RPM_BUILD_DIR/%{name}-%{commit}/doc/AUTHOR %{buildroot}%{_docdir}/%{name}/AUTHOR
install -p -m 0644 $RPM_BUILD_DIR/%{name}-%{commit}/doc/GPLv2 %{buildroot}%{_docdir}/%{name}/GPLv2
install -p -m 0644 $RPM_BUILD_DIR/%{name}-%{commit}/doc/GPLv3 %{buildroot}%{_docdir}/%{name}/GPLv3
install -p -m 0644 $RPM_BUILD_DIR/%{name}-%{commit}/doc/LICENSE %{buildroot}%{_docdir}/%{name}/LICENSE
install -p -m 0644 $RPM_BUILD_DIR/%{name}-%{commit}/doc/README %{buildroot}%{_docdir}/%{name}/README
install -p -m 0644 $RPM_BUILD_DIR/%{name}-%{commit}/doc/%{name}.1.gz %{buildroot}%{_mandir}/man1/%{name}.1.gz

%files
%{_bindir}/%{name}
%dir %{_datarootdir}/%{name}
%{_datarootdir}/%{name}/arrow-down.gif
%{_datarootdir}/%{name}/arrow-none.gif
%{_datarootdir}/%{name}/arrow-up.gif
%{_datarootdir}/%{name}/%{name}.css
%{_datarootdir}/%{name}/sortable.js
#doc %{_docdir}/%{name}
%doc %{_mandir}/man1/%{name}.1*

%changelog
