BuildRequires: chrpath
Group: Development/Tools
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++ imake libXt-devel pkgconfig(libxml-2.0) xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global po_package glade-2.0

Summary:        User Interface Designer for GTK+ 2, legacy version
Name:           glade2
Version:        2.12.2
Release:        alt3_37
License:        GPLv2+ and GFDL
URL:            http://glade.gnome.org/
Source:         http://download.gnome.org/sources/glade/2.12/glade-%{version}.tar.bz2
# Fedora specific patches
Patch0:         gnome-i18n.patch
Patch1:         gtk-includes.patch
# https://fedoraproject.org/wiki/Format-Security-FAQ
Patch2:         glade-2.12.2-format-security.patch

BuildRequires:  gcc
BuildRequires: glib2-devel libgio libgio-devel 
BuildRequires: libpango-devel libpango-gir-devel
BuildRequires: gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires: libgnomeui-devel
BuildRequires: libbonobo-devel
BuildRequires: libbonoboui-devel
BuildRequires: gnome-vfs-devel 
BuildRequires: libgnomecanvas-devel 
BuildRequires: desktop-file-utils 
BuildRequires: scrollkeeper
BuildRequires: gettext gettext-tools
BuildRequires: perl(XML/Parser.pm)
Source44: import.info

%description
The glade2 package contains a legacy version of Glade for GTK+ 2.x. Do not use
it for new projects, use glade (for GTK+ 3.x) or glade3 (for GTK+ 2.x) instead.

Glade is a free user interface builder for GTK+ and the GNOME GUI
desktop. Glade can produce C source code. Support for C++, Ada95,
Python, and Perl is also available, via external tools which process
the XML interface description files output by GLADE.

%prep
%setup -q -n glade-%{version}
%patch0 -p1 -b .gnome-i18n
%patch1 -p1 -b .gtk-includes
%patch2 -p1 -b .format-security

# Fix the warnings from desktop-file-install 
sed -i 's|Icon=glade-2.png|Icon=glade-2|g' glade-2.desktop.in
sed -i 's|MimeType=application/x-glade|MimeType=application/x-glade;|g' glade-2.desktop.in

# It's sr@latin, not sr@Latn
mv -f po/sr@Latn.po po/sr@latin.po
sed -i 's|sr@Latn|sr@latin|g' po/LINGUAS

%build
%configure --disable-gnome-db 
%make_build

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"

desktop-file-install --vendor gnome --delete-original       \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications             \
  --add-category X-Red-Hat-Base                             \
  $RPM_BUILD_ROOT%{_datadir}/applications/*

rm -rf $RPM_BUILD_ROOT/var/scrollkeeper

%find_lang %po_package --all-name --with-gnome
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin,/usr/games} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done

%files -f %{po_package}.lang
%doc AUTHORS COPYING README NEWS TODO
%{_datadir}/glade-2
%{_datadir}/applications/gnome-glade-2.desktop
%{_datadir}/pixmaps/*
%{_bindir}/*

%changelog
