Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global _hardened_build 1

Name:		globus-gass-server-ez
%global _name %(tr - _ <<< %{name})
Version:	6.2
Release:	alt1_6
Summary:	Grid Community Toolkit - Globus Gass Server_ez

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15
BuildRequires:	globus-gass-transfer-devel >= 7
BuildRequires:	globus-gssapi-gsi-devel >= 10
BuildRequires:	globus-gss-assist-devel >= 8
Source44: import.info

%package progs
Group: Networking/WWW
Summary:	Grid Community Toolkit - Globus Gass Server_ez Programs
Requires:	%{name} = %{version}-%{release}

%package devel
Group: Development/Other
Summary:	Grid Community Toolkit - Globus Gass Server_ez Development Files
Requires:	%{name} = %{version}-%{release}

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Globus Gass Server_ez

%description progs
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-progs package contains:
Globus Gass Server_ez Programs

%description devel
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-devel package contains:
Globus Gass Server_ez Development Files

%prep
%setup -q -n %{_name}-%{version}

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name}

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE



%files
%{_libdir}/libglobus_gass_server_ez.so.*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%files progs
%{_bindir}/globus-gass-server
%{_bindir}/globus-gass-server-shutdown

%files devel
%{_includedir}/globus/*
%{_libdir}/libglobus_gass_server_ez.so
%{_libdir}/pkgconfig/%{name}.pc

%changelog
