Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-macros-fedora-compat
BuildRequires: perl(Globus/Core/Config.pm) perl(Globus/Core/Paths.pm) perl(Globus/GRAM/Error.pm) perl(Globus/GRAM/JobManager.pm) perl(Globus/GRAM/JobState.pm) perl-podlators
# END SourceDeps(oneline)
%add_findreq_skiplist %{perl_vendor_privlib}/Globus/GRAM/JobManager/*.pm
BuildRequires: globus-gram-job-manager
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%if %{?fedora}%{!?fedora:0} >= 25 || %{?rhel}%{!?rhel:0} >= 8
%global use_systemd 1
%else
%global use_systemd 0
%endif

Name:		globus-gram-job-manager-sge
%global _name %(tr - _ <<< %{name})
Version:	3.3
Release:	alt1_7
Summary:	Grid Community Toolkit - Grid Engine Job Manager Support

#		The sge.pm file is LGPL-2.1, the rest is Apache-2.0
License:	Apache-2.0 AND LGPL-2.1-only
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15
BuildRequires:	globus-scheduler-event-generator-devel >= 4
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
%if %{use_systemd}
BuildRequires:	libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
%endif

Requires:	globus-gram-job-manager >= 13
Requires:	globus-gram-job-manager-scripts >= 4
Requires:	globus-gass-cache-program >= 5
Requires:	globus-gatekeeper >= 9
Requires:	%{name}-setup = %{version}-%{release}
Source44: import.info

%package setup-poll
Group: Other
Summary:	Grid Community Toolkit - Grid Engine Job Manager Support using polling
BuildArch:	noarch
Provides:	%{name}-setup = %{version}-%{release}
Requires:	%{name} = %{version}-%{release}

Requires(preun):	globus-gram-job-manager-scripts >= 4

%package setup-seg
Group: Other
Summary:	Grid Community Toolkit - Grid Engine Job Manager Support using SEG
Provides:	%{name}-setup = %{version}-%{release}
Requires:	%{name} = %{version}-%{release}
Requires:	globus-scheduler-event-generator-progs >= 4

Requires(preun):	globus-gram-job-manager-scripts >= 4
Requires(preun):	globus-scheduler-event-generator-progs >= 4
Requires(postun):	globus-scheduler-event-generator-progs >= 4
%if %{use_systemd}
%{?systemd_requires}
%else
%endif

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Grid Engine Job Manager Support

%description setup-poll
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-setup-poll package contains:
Grid Engine Job Manager Support using polling to monitor job state

%description setup-seg
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-setup-seg package contains:
Grid Engine Job Manager Support using the scheduler event generator to monitor
job state

%prep
%setup -q -n %{_name}-%{version}

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

export QSUB=%{_bindir}/qsub-ge
export QSTAT=%{_bindir}/qstat-ge
export QDEL=%{_bindir}/qdel-ge
export QCONF=%{_bindir}/qconf
export MPIRUN=no
export SUN_MPRUN=no
%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name} \
	   --with-perlmoduledir=%{perl_vendor_privlib} \
	   --with-globus-state-dir=%{_localstatedir}/log/globus \
	   --with-sge-config=%{_sysconfdir}/sysconfig/gridengine \
	   --with-sge-root=undefined \
	   --with-sge-cell=undefined \
	   --without-queue-validation \
	   --without-pe-validation

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

# Remove jobmanager-sge from install dir - leave it for admin configuration
rm %{buildroot}%{_sysconfdir}/grid-services/jobmanager-sge

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license files from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE
rm %{buildroot}%{_docdir}/%{name}/LICENSE*

%preun setup-poll
if [ $1 -eq 0 ]; then
    globus-gatekeeper-admin -d jobmanager-sge-poll > /dev/null 2>&1 || :
fi

%preun setup-seg
if [ $1 -eq 0 ]; then
    globus-gatekeeper-admin -d jobmanager-sge-seg > /dev/null 2>&1 || :
%if %{use_systemd}
    systemctl --no-reload disable globus-scheduler-event-generator@sge > /dev/null 2>&1 || :
    systemctl stop globus-scheduler-event-generator@sge > /dev/null 2>&1 || :
%else
    /sbin/service globus-scheduler-event-generator stop sge > /dev/null 2>&1 || :
%endif
    globus-scheduler-event-generator-admin -d sge > /dev/null 2>&1 || :
fi

: setup-seg

%postun setup-seg
%{?ldconfig}
if [ $1 -ge 1 ]; then
%if %{use_systemd}
    systemctl try-restart globus-scheduler-event-generator@sge > /dev/null 2>&1 || :
%else
    /sbin/service globus-scheduler-event-generator condrestart sge > /dev/null 2>&1 || :
%endif
fi

%files
%{_datadir}/globus/globus_gram_job_manager/sge.rvf
%dir %{perl_vendor_privlib}/Globus
%dir %{perl_vendor_privlib}/Globus/GRAM
%dir %{perl_vendor_privlib}/Globus/GRAM/JobManager
%{perl_vendor_privlib}/Globus/GRAM/JobManager/sge.pm
%config(noreplace) %{_sysconfdir}/globus/globus-sge.conf
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/AUTHORS
%doc %{_docdir}/%{name}/CREDITS
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE LICENSE*

%files setup-poll
%config(noreplace) %{_sysconfdir}/grid-services/available/jobmanager-sge-poll

%files setup-seg
# This is a loadable module (plugin)
%{_libdir}/libglobus_seg_sge.so
%config(noreplace) %{_sysconfdir}/grid-services/available/jobmanager-sge-seg
%config(noreplace) %{_sysconfdir}/globus/scheduler-event-generator/available/sge

%changelog
