Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/globus-version gcc-c++ libltdl7-devel
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global _hardened_build 1

%if %{?fedora}%{!?fedora:0} >= 25 || %{?rhel}%{!?rhel:0} >= 8
%global use_systemd 1
%else
%global use_systemd 0
%endif

Name:		globus-gridftp-server
%global _name %(tr - _ <<< %{name})
Version:	13.25
Release:	alt1_1
Summary:	Grid Community Toolkit - Globus GridFTP Server

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source1:	%{name}.service
Source2:	globus-gridftp-sshftp.service
Source3:	%{name}
Source4:	globus-gridftp-sshftp
Source8:	README

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 17
BuildRequires:	globus-xio-devel >= 5
BuildRequires:	globus-xio-gsi-driver-devel >= 2
BuildRequires:	globus-gfork-devel >= 3
BuildRequires:	globus-gridftp-server-control-devel >= 9
BuildRequires:	globus-ftp-control-devel >= 7
BuildRequires:	globus-authz-devel >= 2
BuildRequires:	globus-gssapi-gsi-devel >= 10
BuildRequires:	globus-gss-assist-devel >= 9
BuildRequires:	globus-gsi-credential-devel >= 6
BuildRequires:	globus-gsi-sysconfig-devel >= 5
BuildRequires:	globus-io-devel >= 9
BuildRequires:	libssl-devel
BuildRequires:	zlib-devel
BuildRequires:	rpm-build-perl
%if %{use_systemd}
BuildRequires:	libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
%endif
#		Additional requirements for make check
BuildRequires:	openssl
#		Optional test dependency
%if %{?rhel}%{!?rhel:0} == 7
%ifarch ppc64le
#		Fakeroot in EPEL 7 is broken on ppc64le
BuildConflicts:	fakeroot
%else
BuildRequires:	fakeroot
%endif
%else
BuildRequires:	fakeroot
%endif

Requires:	globus-xio-gsi-driver >= 2
%if %{?fedora}%{!?fedora:0} || %{?rhel}%{!?rhel:0} >= 8
Requires:	globus-xio-udt-driver >= 1
%else
Requires:	globus-xio-udt-driver >= 1
%endif
Requires:	globus-common >= 17
Requires:	globus-xio >= 5
Requires:	globus-gridftp-server-control >= 9
Requires:	globus-ftp-control >= 7
Source44: import.info

%package progs
Group: Networking/WWW
Summary:	Grid Community Toolkit - Globus GridFTP Server Programs
Requires:	%{name} = %{version}-%{release}
%if %{use_systemd}
%{?systemd_requires}
%else
%endif

%package devel
Group: Development/C
Summary:	Grid Community Toolkit - Globus GridFTP Server Development Files
Requires:	%{name} = %{version}-%{release}

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Globus GridFTP Server

%description progs
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-progs package contains:
Globus GridFTP Server Programs

%description devel
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-devel package contains:
Globus GridFTP Server Development Files

%prep
%setup -q -n %{_name}-%{version}

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

export GRIDMAP=%{_sysconfdir}/grid-security/grid-mapfile
export GLOBUS_VERSION=6.2
%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name}

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

mv %{buildroot}%{_sysconfdir}/gridftp.conf.default \
   %{buildroot}%{_sysconfdir}/gridftp.conf
mkdir -p %{buildroot}%{_sysconfdir}/xinetd.d
mv %{buildroot}%{_sysconfdir}/gridftp.xinetd.default \
   %{buildroot}%{_sysconfdir}/xinetd.d/gridftp
mv %{buildroot}%{_sysconfdir}/gridftp.gfork.default \
   %{buildroot}%{_sysconfdir}/gridftp.gfork

# No need for environment in conf files
sed '/ env /d' -i %{buildroot}%{_sysconfdir}/gridftp.gfork
sed '/^env /d' -i %{buildroot}%{_sysconfdir}/xinetd.d/gridftp

# Remove start-up scripts
rm -rf %{buildroot}%{_sysconfdir}/init.d

# Install start-up scripts
%if %{use_systemd}
mkdir -p %{buildroot}%{_unitdir}
install -m 644 -p %{SOURCE1} %{SOURCE2} %{buildroot}%{_unitdir}
%else
mkdir -p %{buildroot}%{_initddir}
install -p %{SOURCE3} %{SOURCE4} %{buildroot}%{_initddir}
%endif

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

mkdir -p $RPM_BUILD_ROOT`dirname /etc/sysconfig/globus-gridftp-server`
touch $RPM_BUILD_ROOT/etc/sysconfig/globus-gridftp-server

mkdir -p $RPM_BUILD_ROOT`dirname /etc/sysconfig/globus-gridftp-sshftp`
touch $RPM_BUILD_ROOT/etc/sysconfig/globus-gridftp-sshftp

%check
%make_build check



%if %{use_systemd}

%pre progs
/sbin/chkconfig --del %{name} > /dev/null 2>&1 || :
/sbin/chkconfig --del globus-gridftp-sshftp > /dev/null 2>&1 || :

%post progs
%post_service %{name}
%post_service globus-gridftp-sshftp

%preun progs
%preun_service %{name}
%preun_service globus-gridftp-sshftp

%else
%post progs
if [ $1 -eq 1 ]; then
    /sbin/chkconfig --add %{name}
    /sbin/chkconfig --add globus-gridftp-sshftp
fi

%preun progs
if [ $1 -eq 0 ]; then
    /sbin/service %{name} stop > /dev/null 2>&1 || :
    /sbin/service globus-gridftp-sshftp stop > /dev/null 2>&1 || :
    /sbin/chkconfig --del %{name}
    /sbin/chkconfig --del globus-gridftp-sshftp
fi

%postun progs
if [ $1 -ge 1 ]; then
    /sbin/service %{name} condrestart > /dev/null 2>&1 || :
    /sbin/service globus-gridftp-sshftp condrestart > /dev/null 2>&1 || :
fi

%endif

%files
%{_libdir}/libglobus_gridftp_server.so.*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE
%config(noreplace,missingok) /etc/sysconfig/globus-gridftp-server
%config(noreplace,missingok) /etc/sysconfig/globus-gridftp-sshftp

%files progs
%{_sbindir}/gfs-dynbe-client
%{_sbindir}/gfs-gfork-master
%{_sbindir}/globus-gridftp-password
%{_sbindir}/globus-gridftp-server
%{_sbindir}/globus-gridftp-server-enable-sshftp
%{_sbindir}/globus-gridftp-server-setup-chroot
%config(noreplace) %{_sysconfdir}/gridftp.conf
%config(noreplace) %{_sysconfdir}/gridftp.gfork
%config(noreplace) %{_sysconfdir}/xinetd.d/gridftp
%if %{use_systemd}
%{_unitdir}/%{name}.service
%{_unitdir}/globus-gridftp-sshftp.service
%else
%{_initddir}/%{name}
%{_initddir}/globus-gridftp-sshftp
%endif
%doc %{_mandir}/man8/globus-gridftp-password.8*
%doc %{_mandir}/man8/globus-gridftp-server.8*
%doc %{_mandir}/man8/globus-gridftp-server-setup-chroot.8*

%files devel
%{_includedir}/globus/*
%{_libdir}/libglobus_gridftp_server.so
%{_libdir}/pkgconfig/%{name}.pc

%changelog
