Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-gss-assist
%global _name %(tr - _ <<< %{name})
Version:	12.7
Release:	alt1_6
Summary:	Grid Community Toolkit - GSSAPI Assist library

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15
BuildRequires:	globus-gsi-sysconfig-devel >= 7
BuildRequires:	globus-gsi-cert-utils-devel >= 8
BuildRequires:	globus-gssapi-gsi-devel >= 13
BuildRequires:	globus-callout-devel >= 2
BuildRequires:	globus-gsi-credential-devel >= 6
BuildRequires:	doxygen
BuildRequires:	rpm-build-perl
#		Additional requirements for make check
BuildRequires:	openssl
BuildRequires:	perl-devel
BuildRequires:	perl(English.pm)
BuildRequires:	perl(Fcntl.pm)
BuildRequires:	perl(File/Basename.pm)
BuildRequires:	perl(File/Copy.pm)
BuildRequires:	perl(FileHandle.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(File/Temp.pm)
BuildRequires:	perl(Getopt/Long.pm)
BuildRequires:	perl(POSIX.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(warnings.pm)

Requires:	globus-gsi-sysconfig >= 7
Requires:	globus-gssapi-gsi >= 13
Source44: import.info

%package progs
Group: Networking/WWW
Summary:	Grid Community Toolkit - GSSAPI Assist library Programs
BuildArch:	noarch

%package devel
Group: Development/Other
Summary:	Grid Community Toolkit - GSSAPI Assist library Development Files
Requires:	%{name} = %{version}-%{release}

%package doc
Group: Documentation
Summary:	Grid Community Toolkit - GSSAPI Assist library Documentation Files
BuildArch:	noarch

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
GSSAPI Assist library

%description progs
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-progs package contains:
GSSAPI Assist library Programs

%description devel
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-devel package contains:
GSSAPI Assist library Development Files

%description doc
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-doc package contains:
GSSAPI Assist library Documentation Files

%prep
%setup -q -n %{_name}-%{version}

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name}

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%check
%make_build check



%files
%{_libdir}/libglobus_gss_assist.so.*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%files progs
%{_sbindir}/grid-mapfile-add-entry
%{_sbindir}/grid-mapfile-check-consistency
%{_sbindir}/grid-mapfile-delete-entry
%doc %{_mandir}/man8/grid-mapfile-add-entry.8*
%doc %{_mandir}/man8/grid-mapfile-check-consistency.8*
%doc %{_mandir}/man8/grid-mapfile-delete-entry.8*
%doc --no-dereference GLOBUS_LICENSE

%files devel
%{_includedir}/globus/*
%{_libdir}/libglobus_gss_assist.so
%{_libdir}/pkgconfig/%{name}.pc

%files doc
%doc %{_mandir}/man3/*
%dir %{_docdir}/%{name}
%dir %{_docdir}/%{name}/html
%doc %{_docdir}/%{name}/html/*
%doc --no-dereference GLOBUS_LICENSE

%changelog
