Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires: pkgconfig(globus-common)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-simple-ca
%global _name %(tr - _ <<< %{name})
Version:	5.4
Release:	alt1_6
Summary:	Grid Community Toolkit - Simple CA Utility

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README
BuildArch:	noarch

BuildRequires:	openssl
#		Additional requirements for make check
BuildRequires:	globus-common-progs >= 15
BuildRequires:	perl-devel
BuildRequires:	perl(File/Temp.pm)
BuildRequires:	perl(IPC/Open3.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Symbol.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(warnings.pm)

Requires:	globus-common-progs >= 15
Requires:	globus-gsi-cert-utils-progs
Requires:	openssl
Source44: import.info

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Simple CA Utility

%prep
%setup -q -n %{_name}-%{version}

%build
%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name}

%make_build

%install
%makeinstall_std

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%check
%make_build check

%files
%{_bindir}/grid-ca-create
%{_bindir}/grid-ca-package
%{_bindir}/grid-ca-sign
%doc %{_mandir}/man1/grid-ca-create.1*
%doc %{_mandir}/man1/grid-ca-package.1*
%doc %{_mandir}/man1/grid-ca-sign.1*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%changelog
