Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: libltdl7-devel pkgconfig(globus-xio-pipe-driver)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-xio-gridftp-driver
%global _name %(tr - _ <<< %{name})
Version:	3.6
Release:	alt1_6
Summary:	Grid Community Toolkit - Globus XIO GridFTP Driver

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15
BuildRequires:	globus-xio-devel >= 3
BuildRequires:	globus-ftp-client-devel >= 7
BuildRequires:	globus-xio-gsi-driver-devel >= 2
BuildRequires:	doxygen
BuildRequires:	perl-devel
BuildRequires:	perl(strict.pm)
#		Additional requirements for make check
BuildRequires:	globus-gridftp-server-devel >= 7
BuildRequires:	globus-gridftp-server-progs >= 7
BuildRequires:	openssl
BuildRequires:	perl(Cwd.pm)
BuildRequires:	perl(File/Basename.pm)
BuildRequires:	perl(File/Compare.pm)
BuildRequires:	perl(File/Temp.pm)
BuildRequires:	perl(Getopt/Long.pm)
BuildRequires:	perl(IPC/Open3.pm)
BuildRequires:	perl(lib.pm)
BuildRequires:	perl(Symbol.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(vars.pm)
BuildRequires:	perl(warnings.pm)

Requires:	globus-xio-gsi-driver >= 2
Source44: import.info

%package devel
Group: Other
Summary:	Grid Community Toolkit - Globus XIO GridFTP Driver Development Files
Requires:	%{name} = %{version}-%{release}

%package doc
Group: Other
Summary:	Grid Community Toolkit - Globus XIO GridFTP Driver Documentation Files
BuildArch:	noarch

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Globus XIO GridFTP Driver

%description devel
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-devel package contains:
Globus XIO GridFTP Driver Development Files

%description doc
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-doc package contains:
Globus XIO GridFTP Driver Documentation Files

%prep
%setup -q -n %{_name}-%{version}

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name}

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%check
GLOBUS_HOSTNAME=localhost %make_build check



%files
# This is a loadable module (plugin)
%{_libdir}/libglobus_xio_gridftp_driver.so
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%files devel
%{_includedir}/globus/*
%{_libdir}/pkgconfig/%{name}.pc

%files doc
%doc %{_mandir}/man3/*
%dir %{_docdir}/%{name}
%dir %{_docdir}/%{name}/html
%doc %{_docdir}/%{name}/html/*
%doc --no-dereference GLOBUS_LICENSE

%changelog
