%global pluginname   pdf

Name:           glpi-pdf
Version:        0.83.3
Release:        alt1_4
Summary:        GLPI Plugin to print PDF of equipment
Summary(fr):    Extension GLPI pour créer des PDF des matériels

Group:          Networking/WWW
License:        GPLv2+
URL:            https://forge.indepnet.net/projects/pdf

Source0:        https://forge.indepnet.net/attachments/download/1213/glpi-pdf-0.83.3.tar.gz

BuildArch:      noarch

Requires:       glpi >= 0.83.3
Conflicts:      glpi >= 0.84
Source44: import.info


%description
This GLPI plugin enables you to print, in pdf format, the information 
sheet of an equipment or a software of the inventory. 


%description -l fr
Cette extension GLPI vous permet de créer un PDF contenant toutes les
informations sur un équipement ou un logiciel de l'inventaire.


%prep
%setup -q -c

# dos2unix to avoid rpmlint warnings
mv %{pluginname}/docs docs
for doc in docs/* ; do
    sed -i -e 's/\r//' $doc
done


%build
# empty build

%install

mkdir -p %{buildroot}/%{_datadir}/glpi/plugins
cp -ar %{pluginname} %{buildroot}/%{_datadir}/glpi/plugins/%{pluginname}

for i in %{buildroot}/%{_datadir}/glpi/plugins/%{pluginname}/locales/*
do
  lang=$(basename $i)
  echo "%lang(${lang:0:2}) %{_datadir}/glpi/plugins/%{pluginname}/locales/${lang}"
done | tee %{name}.lang


%files -f %{name}.lang
%doc docs/* %{pluginname}/LICENSE
%dir %{_datadir}/glpi/plugins/%{pluginname}
%dir %{_datadir}/glpi/plugins/%{pluginname}/locales
%{_datadir}/glpi/plugins/%{pluginname}/*.php
%{_datadir}/glpi/plugins/%{pluginname}/fonts
%{_datadir}/glpi/plugins/%{pluginname}/front
%{_datadir}/glpi/plugins/%{pluginname}/inc
%{_datadir}/glpi/plugins/%{pluginname}/pics
# Keep here as required from interface
%{_datadir}/glpi/plugins/%{pluginname}/LICENSE


%changelog
