# BEGIN SourceDeps(oneline):
BuildRequires(pre): libGConf-devel
# END SourceDeps(oneline)
%define fedora 19
Name:         gnome-exe-thumbnailer
Version:      0.8
Release:      alt1_6
Summary:      Shows thumbnails of exe files in nautilus

Group:        Graphical desktop/Other
License:      LGPLv2+
URL:          https://launchpad.net/ubuntu/+source/%{name}/%{version}-0ubuntu1
Source:       https://launchpad.net/ubuntu/+archive/primary/+files/%{name}_%{version}-0ubuntu1.tar.gz
#Redhat Bugzilla #636819 comment 29, Upstream bug https://bugs.launchpad.net/ubuntu/+source/gnome-exe-thumbnailer/+bug/752578
Source1:      %{name}.thumbnailer
Requires:     fonts-bitmap-misc glibc-utils icoutils ImageMagick gawk grep
%if 0%{?fedora} < 15
Requires:     GConf2
%endif
BuildArch:    noarch
Source44: import.info

%description
%{name} is a thumbnailer for Gnome that will give Windows .exe
files an icon based on their embedded icon and a generic "Wine program" icon.
If the program has normal execute permissions, then the standard embedded icon
will be shown.  This thumbnailer will also give a thumbnail icon for .jar, .py, 
and similar executable programs.

%prep
%setup -q
mv debian/README ./
rm -fr debian

%build
%{nil}

%install
install -d $RPM_BUILD_ROOT%{_bindir}
install -d $RPM_BUILD_ROOT%{_sysconfdir}
install -d $RPM_BUILD_ROOT%{_sysconfdir}/gconf
install -d $RPM_BUILD_ROOT%{_sysconfdir}/gconf/schemas
install -d $RPM_BUILD_ROOT%{_datadir}/pixmaps/
install -d $RPM_BUILD_ROOT%{_datadir}/pixmaps/gnome-exe-thumbnailer
install -pm 755 %{name}.sh $RPM_BUILD_ROOT%{_bindir}/
%if 0%{?fedora} < 15
install -pm 644 %{name}.schemas $RPM_BUILD_ROOT%{_sysconfdir}/gconf/schemas/
%else
install -Dpm 644 %{SOURCE1} $RPM_BUILD_ROOT%{_datadir}/thumbnailers/%{name}.thumbnailer
%endif
#Install pixmaps. This is ugly, I'll request a propper installation script from upstream.
#Also I really don't like the new theme, the previous one was better. I wonder if this is a sort of change I can do downstream?
cd pixmaps/%{name}
install -d $RPM_BUILD_ROOT%{_datadir}/pixmaps/gnome-exe-thumbnailer/gnome
install -pm 644 gnome/template.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}/gnome/
install -pm 644 gnome/installer.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}/gnome/
install -d $RPM_BUILD_ROOT%{_datadir}/pixmaps/gnome-exe-thumbnailer/tango
install -pm 644 tango/template.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}/tango/
install -pm 644 tango/installer.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}/tango/
install -d $RPM_BUILD_ROOT%{_datadir}/pixmaps/gnome-exe-thumbnailer/faenza
install -pm 644 faenza/template.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}/faenza/
install -pm 644 faenza/installer.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}/faenza/
install -d $RPM_BUILD_ROOT%{_datadir}/pixmaps/gnome-exe-thumbnailer/elementary
install -pm 644 elementary/template.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}/elementary/
install -pm 644 elementary/installer.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}/elementary/
%if 0%{?fedora} < 15
%post
%gconf2_install %{name}
%endif

%if 0%{?fedora} < 15
%preun
if [ "$1" -eq 0 ]; then
    %gconf2_uninstall  %{name}
fi
%endif

%files
%doc README LICENSE
%{_bindir}/%{name}.sh
%if 0%{?fedora} < 15
%config %{_sysconfdir}/gconf/schemas/%{name}.schemas
%else
%{_datadir}/thumbnailers/%{name}.thumbnailer
%endif
%{_datadir}/pixmaps/%{name}/*

%changelog
