Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install pkgconfig(glade-sharp-2.0) pkgconfig(glib-sharp-2.0) pkgconfig(gtk-sharp-2.0)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This mono package produces an empty debuginfo package. Hence we disable it
%global debug_package %{nil}

Name:            gnome-guitar
Summary:         A small suite of applications for the guitarist
Version:         0.8.1
Release:         alt2_33
License:         GPLv3+
URL:             http://gnome-chord.sourceforge.net/
Source0:         http://downloads.sourceforge.net/gnome-chord/%{name}_cs-%{version}.tar.gz

# Mono only available on these:
ExclusiveArch:   %{mono_arches}

BuildRequires:   desktop-file-utils
BuildRequires:   libgnome-sharp-devel
BuildRequires:   libgtk-sharp2-devel
BuildRequires:   ImageMagick-tools
BuildRequires:   mono-core mono-data mono-data-oracle mono-devel mono-dyndata mono-extras mono-mono2-compat mono-mono2-compat-devel mono-mvc mono-wcf mono-web mono-winforms mono-winfx

Requires:        mono(gconf-sharp)
Requires:        icon-theme-hicolor
Requires(pre):   GConf libGConf
Requires(post):  GConf libGConf
Requires(preun): GConf libGConf
Source44: import.info


%description
Gnome Guitar is chord and scale database for gnome. It can be used as a stand
alone application (for example you could use it to find how to play a specific
chord or scale) or it can integrate with other applications to provide chord
selection and rendering. 

%package devel
Group: Development/Other
Summary:       Development files for %{name}
Requires:      pkgconfig
Requires:      %{name} = %{version}-%{release}

%description devel
Gnome Guitar is chord and scale database for gnome. It can be used as a stand
alone application (for example you could use it to find how to play a specific
chord or scale) or it can integrate with other applications to provide chord
selection and rendering.

This package contains pkg-config files for developing applications that will
use Gnome Guitar.

%prep
%setup -q -n %{name}_cs-%{version}

# Fix permission
chmod 644 gnome-chord/gpl-3.0.txt

# Add pixmaps to the desktop files
echo "Icon=gnome-chord" >> gnome-chord/gnome-chord.desktop
echo "Icon=gnome-scale" >> gnome-scale/gnome-scale.desktop

%build
%configure --disable-schemas-install
%make_build

%install
make install DESTDIR=$RPM_BUILD_ROOT

# The provided fonts are non-square. We iron them out with some Magick
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/64x64/apps/
convert gnome-chord/pixmaps/gnome-chord-logo.png -resize 64x64\! \
        $RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/64x64/apps/gnome-chord.png
convert gnome-scale/pixmaps/gnome-scale-logo.png -resize 64x64\! \
        $RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/64x64/apps/gnome-scale.png

desktop-file-install                                    \
--add-category="AudioVideo"                             \
--add-category="X-AudioVideoTools"                      \
--dir=%{buildroot}%{_datadir}/applications              \
%{buildroot}/%{_datadir}/applications/gnome-chord.desktop

desktop-file-install                                    \
--add-category="AudioVideo"                             \
--add-category="X-AudioVideoTools"                      \
--dir=%{buildroot}%{_datadir}/applications              \
%{buildroot}/%{_datadir}/applications/gnome-scale.desktop


%pre
if [ "$1" -gt 1 ] ; then
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-uninstall-rule \
   %{_sysconfdir}/gconf/schemas/libgnomeguitar.schemas >/dev/null || :
fi

%preun
if [ "$1" -eq 0 ] ; then
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-uninstall-rule \
   %{_sysconfdir}/gconf/schemas/libgnomeguitar.schemas > /dev/null || :
fi

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule \
   %{_sysconfdir}/gconf/schemas/libgnomeguitar.schemas > /dev/null || :


%files
%doc gnome-chord/gpl-3.0.txt
%config %{_sysconfdir}/gconf/schemas/libgnomeguitar.schemas
%{_bindir}/gnome-chord
%{_bindir}/gnome-scale
%{_libdir}/%{name}_cs/
%{_datadir}/applications/gnome-chord.desktop
%{_datadir}/applications/gnome-scale.desktop
%{_datadir}/icons/hicolor/64x64/apps/gnome-chord.png
%{_datadir}/icons/hicolor/64x64/apps/gnome-scale.png

%files devel
%{_libdir}/pkgconfig/libgnomeguitar.pc
%{_libdir}/pkgconfig/libgnomeguitarui.pc

%changelog
