Group: Development/Tools
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Run an entire GNOME session under valgrind
Name:		gnome-valgrind-session
Version:	1.1
Release:	alt2_32
License:	Public Domain
URL:		http://hp.cl.no/proj/gnome-valgrind-session/
Source0:	http://hp.cl.no/proj/gnome-valgrind-session/src/%{name}-%{version}.tar.bz2
Patch0:		%{name}-%{version}-desktop.patch
Patch1:		%{name}-%{version}-use-gnome-session-suffix-pid-drop-alignment.patch
Patch2:		%{name}-%{version}-add-xorg-label.patch

Requires:	gnome-session 
Requires:	valgrind

BuildArch:	noarch
Source44: import.info

%description
GNOME Valgrind Session adds new types of GNOME session to the login manager's
session menu. These let you instrument your entire session with Valgrind for
debugging purposes. The generated logs are collected and subjected to simple
postprocessing when you log out. The result is saved to a file in your home
directory.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1

%build

%install
mkdir -p $RPM_BUILD_ROOT/%{_bindir}
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/xsessions

# Startup and post-processing scripts for the sessions.
install -p -m0755 gnome-valgrind-errors $RPM_BUILD_ROOT/%{_bindir}
install -p -m0755 gnome-valgrind-errors-postprocess $RPM_BUILD_ROOT/%{_bindir}
install -p -m0755 gnome-valgrind-leaks $RPM_BUILD_ROOT/%{_bindir}
install -p -m0755 gnome-valgrind-leaks-postprocess $RPM_BUILD_ROOT/%{_bindir}

# These desktop files represent sessions, not GUI apps, so we don't use
# desktop-file-install upon them (following precedent in the gnome-session
# package).
install -p -m0644 gnome-valgrind-errors.desktop \
  $RPM_BUILD_ROOT/%{_datadir}/xsessions
install -p -m0644 gnome-valgrind-leaks.desktop \
  $RPM_BUILD_ROOT/%{_datadir}/xsessions

%files
%doc LICENSE
%{_bindir}/gnome-valgrind-errors
%{_bindir}/gnome-valgrind-errors-postprocess
%{_bindir}/gnome-valgrind-leaks
%{_bindir}/gnome-valgrind-leaks-postprocess
%{_datadir}/xsessions/gnome-valgrind-errors.desktop
%{_datadir}/xsessions/gnome-valgrind-leaks.desktop

%changelog
