# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/perl5 gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 2.26.0
%define major	1
%define api_version 2.6

%define glibmm_version 2.4.0
%define gnome_vfs_version 2.8.1

%define pkgname gnome-vfsmm
%define libname		lib%{pkgname}%{api_version}_%{major}
%define libname_orig	lib%{pkgname}%{api_version}
%define develname lib%{pkgname}%{api_version}-devel

%define url_ver	%(echo %{version}|cut -d. -f1,2)

Name:		%{pkgname}%{api_version}
Summary:	A C++ interface for GNOME VFS library
Version:	2.26.0
Release:	alt1_17
License:	LGPLv2+
Group:		System/Libraries
Source:		https://download.gnome.org/sources/%{pkgname}/%{url_ver}/%{pkgname}-%{version}.tar.bz2
URL:		http://gtkmm.sourceforge.net/
BuildRequires:	pkgconfig(gnome-vfs-2.0) >= %{gnome_vfs_version}
BuildRequires:	pkgconfig(glibmm-2.4) >= %{glibmm_version}
BuildRequires:	doxygen
Source44: import.info

%description
This package provides a C++ interface for gnome-vfs (the GNOME
Virtual File System), which provides an abstraction to common file
system operations like reading, writing and copying files, listing
directories and so on.  It is a subpackage of the gnomemm project,
which provides a C++ interface for GNOME libraries.

%package	-n %{libname}
Summary:	%{summary}
Group:		%{group}
Provides:	%{name} = %{version}-%{release}
Provides:	%{libname_orig} = %{version}-%{release}

%description	-n %{libname}
This package provides a C++ interface for gnome-vfs (the GNOME
Virtual File System), which provides an abstraction to common file
system operations like reading, writing and copying files, listing
directories and so on.  It is a subpackage of the gnomemm project,
which provides a C++ interface for GNOME libraries.


%package	-n %develname
Summary:	Headers and development files of GNOME VFS C++ wrapper
Group:		Development/GNOME and GTK+
Provides:	%{name}-devel = %{version}-%{release}
Provides:	%{libname_orig}-devel = %{version}-%{release}
Requires:	%{libname} = %{version}
Obsoletes: lib%{pkgname}2.6_1-devel

%description -n %develname
This package contains the headers and various development files needed,
when compiling or developing programs which want C++ wrapper of GNOME
VFS library.

%package	doc
Summary:	Documentation of %{pkgname} library
Group:		Documentation
BuildArch: noarch

%description doc
This package provides API documentation of %{pkgname} library.


%prep
%setup -q -n %pkgname-%version

%build
export CXXFLAGS="%{optflags} -std=gnu++11"
%configure --disable-static
%make_build

### Build doc
pushd docs/reference
  perl -pi -e 's/^(HAVE_DOT.*=) YES/$1 NO/' Doxyfile
  make all
popd

%install
%makeinstall_std
find %buildroot -name '*.la' -delete

%files -n %{libname}
%doc COPYING
%{_libdir}/libgnomevfsmm-%{api_version}.so.%{major}*

%files -n %develname
%doc AUTHORS COPYING ChangeLog NEWS README
%{_includedir}/*
%{_libdir}/%{pkgname}-%{api_version}
%{_libdir}/pkgconfig/*.pc
%{_libdir}/*.so

%files doc
%doc docs/reference/html



%changelog
