Group: Security/Networking
# BEGIN SourceDeps(oneline):
BuildRequires(pre): libGConf-devel
BuildRequires: /usr/bin/desktop-file-install /usr/bin/gconftool-2 /usr/bin/glib-gettextize pkgconfig(gdk-pixbuf-2.0) pkgconfig(glib-2.0) pkgconfig(gthread-2.0) pkgconfig(gtk+-2.0) pkgconfig(iso-codes)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		gnomint
Version:	1.3.0
Release:	alt1_10
Summary:	Graphical x509 Certification Authority management tool
License:	GPLv3+
URL:		http://gnomint.sourceforge.net/
Source0:	http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Patch0:		%{name}-1.2.1-DSO-libgcrypt.patch
# Stopping the use of deprecated functions
Patch1:		https://github.com/davefx/gnoMint/commit/86e2074a9934d387affed1aa34b4d61c498c8500.patch
# Fix argument order for addcsr call
Patch2:		https://github.com/davefx/gnoMint/commit/74d79401f9807923d1564e7f11a1b18dc995fe52.patch
# Allow setting of cflags and remove -Werror
Patch3:		https://github.com/davefx/gnoMint/commit/93c88d4dd92e2c7fa3d364048d689f3d4d0aa64f.patch
# Add missing Makefile.am
Patch4:		gnomint-1.3.0-missing-Makefile.am.patch

BuildRequires:	libgnutls-devel libgnutlsxx-devel
BuildRequires:	libgnomeui-devel
BuildRequires:	gettext gettext-tools
BuildRequires:	desktop-file-utils
BuildRequires:	perl(XML/Parser.pm)
BuildRequires:	libsqlite3-devel >= 3
BuildRequires:	intltool
BuildRequires:	readline-devel
BuildRequires:	gcrypt-utils libgcrypt-devel
BuildRequires:	autoconf, libtool
BuildRequires:	gcc

Requires(pre):	GConf libGConf
Requires(post):	GConf libGConf
Requires(preun):GConf libGConf
Source44: import.info

%description
Certification Authority management made easy.

gnoMint is a x509 Certification Authority management tool for
GTK/Gnome environments.

%description -l ru_RU.UTF-8
gnoMint позволяет запустить свой Центр Сертификации, создавая
сертификаты для любого назначения: цифровой подписи и/или шифрования
сообщений эл. почты; TLS аутентификации через веб, VPN и других
протоколов, защищённых веб-серверов...
Его разработка была начата вследствии отсутствия 'работающих из коробки'
CA программ. Создания CA с нуля через открытые командные утилиты вполне
возможно,
но неудобно запоминать все необходимые параметры, также требуется
создавать сложные конфигурационные файлы. Поэтому создан gnoMint, он
поможет системным и сетевым администраторам очень легко разворачивать
Центр Сертфикации. На данный момент gnoMint позволяет:

 * Создавать всю инфраструктуру для поддержания и запуска Центра
   Сертификации, сохранённой только в одном файле.
 * Создавать Запросы на подпись Сертификата, позволяя экспортировать их
   в файлы формата PKCS#8, т.о. они могут быть переданы в другие CA.
 * Создавать X.509 сертификаты с обычным набором заголовочных параметров
 * Экспорт сертификатов и закрытых ключей в PEM файлы, т.о. они могут
   быть использованы во внешних приложениях.
 * Для каждого CA устанавливается набор политик для генерации
   сертификатов.
 * Импорт CSR делается другими приложениями
 * Экспорт PKCS#12 структур, т.о. сертификаты могут быть легко
   импортированы веб и почтовыми клиентами.
 * Отзыв сертификатов и создание соотвествующего CRL.
 * Позволяет хранить закрытые ключи CA или других закрытых ключей во
   внешних файлах или носителях (таких как флэш-диски).
 * Позволяет управлять целой иерархией CA со своими сертификатами.
 * Импорт существующих Центров Сертификации со своими данными.
 * Позволяет легко осуществлять CA-операции из коммандной строки для
   пакетного создания сертификатов или интеграции с другими утилитами.

%prep
%setup -q
%patch0 -p1 -b .dso
%patch1 -p1 -b .86e2074a
%patch2 -p1 -b .74d79401
%patch3 -p1 -b .93c88d4d
%patch4 -p1 -b .missing

%build
autoreconf -ifv
%configure --disable-dependency-tracking --disable-schemas-install
%make_build CFLAGS="%{optflags} -Wno-unused-but-set-variable"

%install
make install DESTDIR=%{buildroot} INSTALL="install -p"
desktop-file-install --delete-original \
  --remove-category=Application \
  --dir %{buildroot}%{_datadir}/applications \
  %{buildroot}%{_datadir}/applications/%{name}.desktop

%find_lang %{name}

%preun
if [ "$1" -eq 0 ]; then
    %gconf2_uninstall  %{name}
fi

%post
%gconf2_install %{name}

%files -f %{name}.lang
%doc --no-dereference COPYING
%doc README AUTHORS NEWS MAINTAINERS
%doc ChangeLog
%{_bindir}/%{name}
%{_bindir}/%{name}-cli
%{_bindir}/%{name}-upgrade-db
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/*.png
%{_datadir}/mime/packages/%{name}.xml
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/applications/%{name}.desktop
%{_sysconfdir}/gconf/schemas/%{name}.schemas
%{_datadir}/%{name}/*.ui

%changelog
