Group: Graphics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
%define fedora 37
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           goddard-backgrounds
Version:        13.0.0
Release:        alt1_24
Summary:        Goddard desktop backgrounds

License:        CC-BY-SA
URL:            https://fedoraproject.org/wiki/F12_Artwork
Source0:        https://fedorahosted.org/released/design-team/%{name}-%{version}.tar.lzma

BuildArch:      noarch

# for %%_kde4_* macros
Requires:       %{name}-gnome = %{version}-%{release}
Requires:       %{name}-kde = %{version}-%{release}
Source44: import.info


%description
This package contains desktop backgrounds for the Goddard theme. Pulls in both
Gnome and KDE themes.

%package        single
Group: Graphics
Summary:        Single screen images for Goddard Backgrounds

%description    single
This package contains Single screen images for Goddard Backgrounds

%package        kde 
Group: Graphics
Summary:        Goddard Wallpapers for KDE 
%if 0%{?fedora} == 13
Provides:       system-backgrounds-kde
%endif

Requires:       %{name}-single = %{version}-%{release} 

%description    kde 
This package contains KDE desktop wallpapers for the Goddard theme.

%package        gnome 
Group: Graphics
Summary:        Goddard Wallpapers for Gnome 

Requires:       %{name}-single = %{version}-%{release} 
%if 0%{?fedora} == 13
# FIXME: Which provides I should use?
Provides:        system-backgrounds
#Provides:        system-backgrounds-gnome
%endif

%description    gnome 
This package contains Gnome desktop wallpapers for the Goddard theme.


%prep
%setup -q


%build
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT


%files
#doc %_docdir/%name

%files single
%doc COPYING Credits
#There'll be also dual wallpapers in dual subpackage in the future, hence the 
# %%dir ownership is separated
%dir %{_datadir}/backgrounds/goddard
%dir %{_datadir}/backgrounds/goddard/default
%{_datadir}/backgrounds/goddard/default/normalish
%{_datadir}/backgrounds/goddard/default/standard
%{_datadir}/backgrounds/goddard/default/wide

%files kde
%{_kde4_datadir}/wallpapers/Goddard/

%files gnome
%{_datadir}/backgrounds/goddard/default/goddard.xml
%{_datadir}/gnome-background-properties/desktop-backgrounds-goddard.xml


%changelog
