Group: System/Libraries
%define fedora 32
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global  api_ver 1.0

Name:           goocanvasmm
Version:        0.15.4
Release:        alt2_25

Summary:        C++ interface for goocanvas

License:        LGPLv2+
URL:            http://www.gtkmm.org/
Source0:        http://ftp.gnome.org/pub/GNOME/sources/%{name}/0.15/%{name}-%{version}.tar.bz2
Patch0:         goocanvasmm-0.15.4-doctooldir.patch

BuildRequires:  gcc-c++
BuildRequires:  libglibmm-devel >= 2.14.2
BuildRequires:  libgtkmm2-devel >= 2.22.0
BuildRequires:  libgoocanvas-devel >= 0.15
BuildRequires:  mm-common >= 0.9.5
Source44: import.info


%description
This package provides a C++ interface for goocanvas. It is a
subpackage of the gtkmm project. The interface provides a convenient
interface for C++ programmers to create Gnome GUIs with GTK+'s
flexible object-oriented framework.


%package        devel
Group: Development/Other
Summary:        Headers for developing programs that will use %{name}
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%package        doc
Group: Documentation
Summary:        Developer documentation for %{name}
%if 0%{?fedora} > 9 || 0%{?rhel} > 5
BuildArch:      noarch
%endif
BuildRequires:  doxygen graphviz libgraphviz
Requires:       libgtkmm2-doc

%description      doc
This package contains developer's documentation for the goocanvasmm2
library. Goocanvasmm2 is the C++ API for the goocanvas graphics library.

The documentation can be viewed either through the devhelp
documentation browser or through a web browser.

If using a web browser the documentation is at
/usr/share/doc/%%{tarname}-%%{api_ver}

%prep
%setup -q
%patch0 -p1


%build
%configure --enable-shared
%make_build
# Build documentation
(cd doc/reference; doxygen -u 2> /dev/null)


%install
make install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name "*.la" -exec rm -f {} ';'






%files
%doc AUTHORS ChangeLog COPYING NEWS README
%{_libdir}/*.so.*


%files devel
%{_includedir}/%{name}-%{api_ver}
%{_libdir}/%{name}-%{api_ver}
%{_libdir}/*.so
%{_libdir}/pkgconfig/%{name}-%{api_ver}.pc

%files doc
%doc COPYING
%doc %{_datadir}/devhelp/books/%{name}-%{api_ver}
%doc %{_docdir}/%{name}-%{api_ver}


%changelog
