Group: System/Libraries
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global tarname goocanvasmm
%global api_ver 2.0

%global glibmm_version 2.46.1
%global gtkmm_version 3.18.0
%global goocanvas_version 2.0.1

Name:           goocanvasmm2
Version:        1.90.11
Release:        alt2_12
Summary:        C++ interface for goocanvas2

License:        LGPLv2+
URL:            http://www.gtkmm.org/
Source0:        http://ftp.gnome.org/pub/GNOME/sources/%{tarname}/1.90/%{tarname}-%{version}.tar.xz

BuildRequires:  gcc-c++
BuildRequires:  libglibmm-devel >= %{glibmm_version}
BuildRequires:  libgtkmm3-devel >= %{gtkmm_version}
BuildRequires:  libgoocanvas2-devel libgoocanvas2-gir-devel

Requires:       libglibmm >= %{glibmm_version}
Requires:       libgtkmm3 >= %{gtkmm_version}
Requires:       libgoocanvas2 >= %{goocanvas_version}
Source44: import.info

%description
This package provides a C++ interface for goocanvas. It is a
sub-package of the gtkmm project. The interface provides a convenient
interface for C++ programmers to create Gnome GUIs with GTK+'s
flexible object-oriented framework.


%package        devel
Group: Development/Other
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%package        doc
Group: Documentation
Summary:        Developer documentation for %{name}
BuildArch:      noarch
BuildRequires:  doxygen graphviz libgraphviz
Requires:       libgtkmm3-doc

%description      doc
This package contains developer's documentation for the goocanvasmm2
library. Goocanvasmm2 is the C++ API for the goocanvas graphics library.

The documentation can be viewed either through the devhelp
documentation browser or through a web browser.

If using a web browser the documentation is at
/usr/share/doc/%{tarname}-%{api_ver}

%prep
%setup -q -n %{tarname}-%{version}

%build
%configure --disable-static
%make_build


%install
%makeinstall_std
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'





%files
%doc --no-dereference COPYING
%doc AUTHORS NEWS README
%{_libdir}/*.so.*

%files devel
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/%{tarname}-%{api_ver}/
%{_libdir}/pkgconfig/%{tarname}-%{api_ver}.pc

%files doc
%doc --no-dereference COPYING
%doc %{_datadir}/devhelp/books/%{tarname}-%{api_ver}
%doc %{_docdir}/%{tarname}-%{api_ver}


%changelog
