# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           goxel
Version:        0.14.0
Release:        alt1_1
Summary:        3D voxel graphics editor
Group:          Graphics
License:        GPLv3+
URL:            https://github.com/guillaumechereau/goxel
Source0:        https://github.com/guillaumechereau/goxel/archive/v%{version}/%{name}-%{version}.tar.gz

BuildRequires:  ImageMagick-tools libImageMagick7.10
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(glfw3)
BuildRequires:  pkgconfig(gtk+-3.0)
BuildRequires:  pkgconfig(zlib)
BuildRequires:  scons
Source44: import.info

%description
Goxel is an open source voxel graphics editor. Voxels are 3D images formed
of cubic elements). Main features:
- 24 bits RGB colors.
- Unlimited scene size and undo buffer.
- Multiple layers.
- Marching cube and procedural rendering.
- Export to obj, pyl, png, magica voxel, qubicle.

%prep
%setup -q


%build

%scons mode=release werror=0

%install
install -D -m755 %{name} %{buildroot}%{_bindir}/%{name}

install -d %{buildroot}%{_iconsdir}/hicolor/{48x48,256x256,1024x1024}/apps
install -m644 icon.png %{buildroot}%{_iconsdir}/hicolor/1024x1024/apps/%{name}.png
convert icon.png -resize 48x48 %{buildroot}%{_iconsdir}/hicolor/48x48/apps/%{name}.png
convert icon.png -resize 256x256 %{buildroot}%{_iconsdir}/hicolor/256x256/apps/%{name}.png

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Goxel
GenericName=Voxel graphics editor
Comment=3D voxel graphics editor
Exec=%{name}
Icon=%{name}
Type=Application
Categories=Graphics;VectorGraphics;
EOF

%files
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png


%changelog
