Name:        gplcver
Version:     2.12a
Release:     alt1_12
Summary:     An interpreted Verilog HDL simulator

License:     GPLv2
Group:       Engineering
URL:         http://www.pragmatic-c.com/gpl-cver

Source0:     http://www.sourcefiles.org/Scientific/Electronic/%{name}-%{version}.src.tar.bz2
Patch0:      gplcver-2.12a-format-security.patch

Requires:    dinotrace
Source44: import.info

%description
Cver is a full 1995 IEEE P1364 standard Verilog simulator. It also
implements some of the 2001 P1364 standard features. All three
PLI interfaces (tf_, acc_, and vpi_) are implemented as defined
in the IEEE 2001 P1364 LRM.

GPL Cver is an older version of Cver that is released under the GNU
General Public License. A newer and faster commercial version of Cver
is available from Pragmatic C Software Corp.


%prep
%setup -q -n %{name}-%{version}.src
%patch0 -p1

# preserving timestamps while fixing paths
%{__sed} -e "s|../../bin|%{_bindir}|"  \
         vcddiff.dir/examples.vcddiff/vcddiff_test.sh > vcddiff.ex
touch -r vcddiff.dir/examples.vcddiff/vcddiff_test.sh vcddiff.ex
%{__mv} vcddiff.ex vcddiff.dir/examples.vcddiff/vcddiff_test.sh

%{__sed} -e "s|../../../bin|%{_bindir}|"  \
         tests_and_examples/v2001/config/config_tst.sh >> config_tst.ex 
touch -r tests_and_examples/v2001/config/config_tst.sh config_tst.ex
%{__mv} config_tst.ex tests_and_examples/v2001/config/config_tst.sh

%{__sed} -e "s|../../bin|%{_bindir}|"  \
         tests_and_examples/v2001/inst_tst.sh > inst_tst.ex 
touch -r tests_and_examples/v2001/inst_tst.sh inst_tst.ex
%{__mv} inst_tst.ex tests_and_examples/v2001/inst_tst.sh

%{__sed} -e "s|../../bin|%{_bindir}|"  \
         tests_and_examples/examples.tf/inst_pli.sh > inst_pli.ex 
touch -r tests_and_examples/examples.tf/inst_pli.sh inst_pli.ex
%{__mv} inst_pli.ex tests_and_examples/examples.tf/inst_pli.sh

%{__sed} -e "s|../../pli_incs|%{_includedir}/cver|"  \
         tests_and_examples/examples.tf/makefile.lnx > makefile.ex 
touch -r tests_and_examples/examples.tf/makefile.lnx makefile.ex
%{__mv} makefile.ex tests_and_examples/examples.tf/makefile.lnx

%{__sed} -e "s|../../bin|%{_bindir}|"  \
         tests_and_examples/install.tst/inst_tst.sh > inst_tst.ex 
touch -r tests_and_examples/install.tst/inst_tst.sh inst_tst.ex
%{__mv} inst_tst.ex tests_and_examples/install.tst/inst_tst.sh

%{__sed} -e "s|../../bin|%{_bindir}|"  \
         tests_and_examples/examples.acc/inst_pli.sh > inst_pli.ex 
touch -r tests_and_examples/examples.acc/inst_pli.sh inst_pli.ex
%{__mv} inst_pli.ex tests_and_examples/examples.acc/inst_pli.sh

%{__sed} -e "s|../../pli_incs|%{_includedir}/cver|"  \
         tests_and_examples/examples.acc/makefile.lnx > makefile.ex 
touch -r tests_and_examples/examples.acc/makefile.lnx makefile.ex
%{__mv} makefile.ex tests_and_examples/examples.acc/makefile.lnx

%{__sed} -e "s|../../bin|%{_bindir}|"  \
         tests_and_examples/examples.vpi/inst_pli.sh > inst_pli.ex 
touch -r tests_and_examples/examples.vpi/inst_pli.sh inst_pli.ex
%{__mv} inst_pli.ex tests_and_examples/examples.vpi/inst_pli.sh

%{__sed} -e "s|../../pli_incs|%{_includedir}/cver|"  \
         tests_and_examples/examples.vpi/makefile.lnx > makefile.ex 
touch -r tests_and_examples/examples.vpi/makefile.lnx makefile.ex
%{__mv} makefile.ex tests_and_examples/examples.vpi/makefile.lnx


# fixing PATHS in documentation
%{__sed} -e "s|../../bin|%{_bindir}|"  \
         tests_and_examples/capacity.tst/README > README.ex
touch -r tests_and_examples/capacity.tst/README README.ex
%{__mv} README.ex tests_and_examples/capacity.tst/README

%{__sed} -e "s|../../bin|%{_bindir}|"  \
         tests_and_examples/v2001/README > README.ex
touch -r tests_and_examples/v2001/README README.ex
%{__mv} README.ex tests_and_examples/v2001/README

%{__sed} -e "s|../../../bin|%{_bindir}|"  \
         tests_and_examples/v2001/config/README > README.ex
touch -r tests_and_examples/v2001/config/README README.ex
%{__mv} README.ex tests_and_examples/v2001/config/README

%{__sed} -e "s|../../bin|%{_bindir}|"  \
         tests_and_examples/install.tst/README > README.ex
touch -r tests_and_examples/install.tst/README README.ex
%{__mv} README.ex tests_and_examples/install.tst/README

%{__sed} -e "s|../../bin|%{_bindir}|"  \
         tests_and_examples/examples.acc/README > README.ex
touch -r tests_and_examples/examples.acc/README README.ex
%{__mv} README.ex tests_and_examples/examples.acc/README


# fixing optflags
%{__sed} -i \
"s|CFLAGS= \$(ARCHFLGS) -pipe \$(WARNS) \$(INCS) \$(OPTFLGS) -O2|CFLAGS= %{optflags} \$(INCS)|" \
src/makefile.lnx
%{__sed} -i \
"s|CFLAGS= \$(ARCHFLGS) -pipe \$(OPTFLGS) -O2|CFLAGS= %{optflags}|" \
vcddiff.dir/src/makefile.lnx


# remove other OS files
%{__rm} -f `find . -name *cygwin*`
%{__rm} -f `find . -name *osx*`


# remove zero byte file
%{__rm} -f `find . -name xxdel.tst`


# To package scripts in doc, change permissions
find . -name "*.sh" | xargs -i chmod 644 {}
find . -name "*.pl" | xargs -i chmod 644 {}


%build
%{__make} -C src -f makefile.lnx
%{__make} -C vcddiff.dir/src -f makefile.lnx

%install
%{__install} -d %{buildroot}%{_bindir}
%{__install} -d %{buildroot}%{_includedir}/cver
%{__install} -d %{buildroot}%{_mandir}/man1

%{__install} -pm 755 bin/*      %{buildroot}%{_bindir}/
%{__install} -pm 644 pli_incs/* %{buildroot}%{_includedir}/cver/
%{__install} -pm 644 doc/*.1    %{buildroot}%{_mandir}/man1/


# removing duplicates
%{__rm} -f doc/*.1


%files
%doc Changelog COPYING LICENSE OUR_PHILOSOPHY
%doc NEW.CVER.2001.RELEASE.NOTES README doc/
%doc pli_src ver_src tests_and_examples/
%doc vcddiff.dir/examples.vcddiff/
%{_bindir}/cver
%{_bindir}/vcddiff
%{_mandir}/man*/*
%{_includedir}/cver

%changelog
