# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(Fcntl.pm) perl(File/Spec/Functions.pm) perl(FindBin.pm) perl(IO/Seekable.pm)
# END SourceDeps(oneline)
%define formats rom
# ne is only for backwards compat with older versions of qemu
%define qemuroms rtl8029 ne 8086100e pcnet32 rtl8139 virtio-net
%define buildarches %{ix86} x86_64

# debugging firmwares does not goes the same way as a normal program.
# moreover, all architectures providing debuginfo for a single noarch
# package is currently clashing in koji, so don't bother.
%global debug_package %{nil}

Name:    gpxe
Version: 1.0.1
Release: alt2_7
Summary: A network boot loader

Group:   System/Base
License: GPLv2 and BSD
URL:     http://etherboot.org/

Source0: http://git.etherboot.org/releases/%{name}/%{name}-%{version}.tar.bz2
Source1: USAGE
Patch1: %{name}-1.0.1-virtionet-length.patch
Patch2: %{name}-%{version}-banner-timeout.patch

%ifarch %{buildarches}
BuildRequires: perl syslinux mtools mkisofs
Source44: import.info

%package bootimgs
Summary: Network boot loader images in bootable USB, CD, floppy and GRUB formats
Group:   Development/Tools
BuildArch: noarch

%package roms
Summary: Network boot loader roms in .rom format
Group:  Development/Tools
Requires: %{name}-roms-qemu = %{version}-%{release}
BuildArch: noarch

%package roms-qemu
Summary: Network boot loader roms supported by QEMU, .rom format
Group:  Development/Tools
BuildArch: noarch


%description bootimgs
gPXE is an open source network bootloader. It provides a direct
replacement for proprietary PXE ROMs, with many extra features such as
DNS, HTTP, iSCSI, etc.

This package contains the gPXE boot images in USB, CD, floppy, and PXE
UNDI formats.

%description roms
gPXE is an open source network bootloader. It provides a direct
replacement for proprietary PXE ROMs, with many extra features such as
DNS, HTTP, iSCSI, etc.

This package contains the gPXE roms in .rom format.


%description roms-qemu
gPXE is an open source network bootloader. It provides a direct
replacement for proprietary PXE ROMs, with many extra features such as
DNS, HTTP, iSCSI, etc.

This package contains the gPXE ROMs for devices emulated by QEMU, in
.rom format.
%endif

%description
gPXE is an open source network bootloader. It provides a direct
replacement for proprietary PXE ROMs, with many extra features such as
DNS, HTTP, iSCSI, etc.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
cp -a %{SOURCE1} .

%build
%ifarch %{buildarches}
# Fedora 10 and newer, location is in /usr/share.  Older is in /usr/lib.
ISOLINUX_BIN=/usr/share/syslinux/isolinux.bin
[ -e /usr/lib/syslinux/isolinux.bin ] && ISOLINUX_BIN=/usr/lib/syslinux/isolinux.bin
cd src
# NO_WERROR is needed because of bogus (for us) error: variable '__table_entries' set but not used [-Werror=unused-but-set-variable]
make %{?_smp_mflags} ISOLINUX_BIN=${ISOLINUX_BIN} NO_WERROR=1
make %{?_smp_mflags} bin/gpxe.lkrn
make %{?_smp_mflags} allroms
%endif

%install
%ifarch %{buildarches}
mkdir -p %{buildroot}/%{_datadir}/%{name}/
pushd src/bin/

cp -a undionly.kpxe gpxe.{iso,usb,dsk,lkrn} %{buildroot}/%{_datadir}/%{name}/

for fmt in %{formats};do
 for img in *.${fmt};do
      if [ -e $img ]; then
   cp -a $img %{buildroot}/%{_datadir}/%{name}/
   echo %{_datadir}/%{name}/$img >> ../../${fmt}.list
  fi   
 done
done
popd

# the roms supported by qemu will be packaged separatedly
# remove from the main rom list and add them to qemu.list
for fmt in rom ;do 
 for rom in %{qemuroms} ; do
  sed -i -e "/\/${rom}.${fmt}/d" ${fmt}.list
  echo %{_datadir}/%{name}/${rom}.${fmt} >> qemu.${fmt}.list
 done
done
%endif

%ifarch %{buildarches}
%files bootimgs
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/gpxe.iso
%{_datadir}/%{name}/gpxe.usb
%{_datadir}/%{name}/gpxe.dsk
%{_datadir}/%{name}/gpxe.lkrn
%{_datadir}/%{name}/undionly.kpxe
%doc COPYING COPYRIGHTS USAGE

%files roms -f rom.list
%dir %{_datadir}/%{name}
%doc COPYING COPYRIGHTS

%files roms-qemu -f qemu.rom.list
%dir %{_datadir}/%{name}
%doc COPYING COPYRIGHTS
%endif

%changelog
