# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ libtiff-devel perl(XML/DOM.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define recoil_ver 6.1.0
%define sixfivezerotwo_ver 0.1

Name:           grafx2
Version:        2.8
Release:        alt1_1
Summary:        Ultimate 256-color bitmap paint program
Group:          Graphics
License:        GPLv2+
URL:            https://pulkomandy.tk/projects/GrafX2
# https://pulkomandy.tk/projects/GrafX2/downloads
Source0:        https://gitlab.com/GrafX2/grafX2/-/archive/v%{version}/grafX2-v%{version}.tar.gz
# download 3rdparty recoil project
Source1:        https://downloads.sourceforge.net/project/recoil/recoil/%{recoil_ver}/recoil-%{recoil_ver}.tar.gz
# download 3rdparty 6502 project
Source2:        https://github.com/redcode/6502/releases/download/v%{sixfivezerotwo_ver}/6502-v%{sixfivezerotwo_ver}.tar.xz
Patch0:         grafx2-2.6-mga-hicolor-icon.patch
Patch1:         grafx2-2.8-mga-desktop.patch
Patch2:         grafx2-2.8-mga-sdl2.patch
Patch10:        grafX2-v2.8-recoil6.patch

BuildRequires:  pkgconfig(fontconfig)
BuildRequires:  pkgconfig(freetype2)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(lua)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_image)
BuildRequires:  pkgconfig(SDL2_ttf)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(zlib)

Provides:       bundled(recoil) = %{recoil_ver}
Provides:       bundled(6502) = %{sixfivezerotwo_ver}
Source44: import.info

%description
GrafX2 is a bitmap paint program inspired by the Amiga programs a..Deluxe
Paint and Brilliance. Specialized in 256-color drawing, it includes a very
large number of tools and effects that make it particularly suitable
for pixel art, game graphics, and generally any detailed graphics painted
with a mouse.

%prep
%setup -q -n grafX2-v%{version} -a1 -a2
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch10 -p1


# prepare 3rdparty recoil project
mv recoil-%{recoil_ver}/ 3rdparty/recoil-%{recoil_ver}
# prepare 3rdparty 6502 project
mv 6502/ 3rdparty/6502

# Use the newer recoil
sed -i 's|RECOILVER=5.1.1|RECOILVER=%{recoil_ver}|g' 3rdparty/Makefile

%build

%make_build -C src

%install
%makeinstall_std -C src PREFIX=%{_prefix}

install -D -m644 misc/unix/%{name}.1 %{buildroot}%{_mandir}/man1/%{name}.1

%files
%doc doc/README.txt
%doc --no-dereference LICENSE
%{_bindir}/%{name}
%{_datadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/scalable/apps/%{name}.svg
%{_metainfodir}/%{name}.appdata.xml
%{_mandir}/man1/%{name}.1*


%changelog
