# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ pkgconfig(inputproto) pkgconfig(x11) pkgconfig(xext) pkgconfig(xi)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define		_major		6
%define		_name		grail
%define		libname		lib%{_name}%{_major}
%define		devname		lib%{_name}-devel

Name:		%_name
Version:	3.1.1
Release:	alt1_4
License:	GPLv3
Summary:	Gesture Recognition And Instantiation Library
Group:		Development/Other
Url:		https://launchpad.net/grail
Source:		https://launchpad.net/grail/trunk/%{version}/+download/%{name}-%{version}.tar.bz2
#Patch1:		grail-3.0.9-gcc7.patch

BuildRequires:	pkgconfig(mtdev)
BuildRequires:	pkgconfig(evemu)
BuildRequires:	pkgconfig(frame)
Source44: import.info

%description
Grail consists of an interface and tools for handling
gesture recognition and gesture instantiation.

When a multitouch gesture is performed on a device,
the recognizer emits one or several possible gestures.
Once the context of the gesture is known, i.e.,
in what window the touches land and what gestures
the clients of that window listen to, the instantiator
delivers the matching set of gestures.

The library handles tentative gestures, i.e.,
buffering of events for several alternative gestures
until a match is confirmed.

%prep
%setup -q


%build
autoreconf -fi
%configure --disable-static
%make_build

%check
%make_build check

%install
%makeinstall_std

find %{buildroot} -name "*.la" -delete

%files
%doc README COPYING
%{_bindir}/grail*
%{_mandir}/man1/grail*

#---------------------------------------------

%package -n %libname
Summary:        GRAIL Library Package
Group:          System/Libraries

%description -n %libname
This package contains the library needed to run programs
dynamically linked with grail.

%files -n %libname
%{_libdir}/libgrail.so.*

#---------------------------------------------

%package -n %devname
Summary:        Gesture Recognition And Instantiation Library Development Package
Group:          Development/Other
Requires:       %{libname} = %{version}-%{release}
Provides:       %{name}-devel = %{version}-%{release}

%description -n %devname
This package provides headers files for grail development.

%files -n %devname
%{_includedir}/oif/grail.h
%{_libdir}/pkgconfig/grail.pc
%{_libdir}/libgrail.so


%changelog
