Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install /usr/bin/glib-gettextize
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           greyhounds
Version:        0.8
Release:        alt2_0.41.prealpha
Summary:        Greyhounds is a greyhounds racing and breeding game
Summary(pl):    Greyhounds to wyścigi i hodowla chartów
License:        GPLv2
URL:            http://sourceforge.net/projects/byghound
Source0:        http://downloads.sourceforge.net/byghound/%{name}-%{version}-pre-alpha.tar.bz2
Source1:        %{name}.desktop
# Patch 0 should go upstrem
Patch0:		greyhound-am.patch
Patch1:		greyhound-in.patch
Patch2:		greyhound-save.patch
Patch3:		greyhound-gcc10.patch
Patch4:		greyhound-names.patch
Patch5:		greyhounds-configure-c99.patch
Patch6:		greyhounds-c99-headers.patch
BuildRequires:  gcc
BuildRequires:  desktop-file-utils gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel ImageMagick-tools
Requires:       icon-theme-hicolor
Source44: import.info

%description
Greyhounds is a greyhound racing and breeding game. Your goal is to
acquire fast and talented greyhounds and be successful with them in the
races; your two possibilities for doing so are breeding and trading.
Ultimately you should aim at winning the Champions' Trophy. You might
also consider establishing a record that lasts to the end of times a
worthy goal.

%description -l pl
Greyhounds to wyścigi i hodowla chartów. Twoim zadaniem jest zdobyć szybkie
i utalentowane charty i być zadowolonym z ich wyścigów; twoimi dwiema
możliwościami są hodowanie i handlowanie. Ostatecznie powinineś dążyć do
wygraia mistrzowskiego trofeum. Możesz również osiągać nowe rekordy
czasowe.

%prep
%setup -q -n %{name}-%{version}-pre-alpha
%patch0
%patch1
%patch2
%patch3
%patch4
%patch5 -p1
%patch6 -p1

# Create icons and make appropriate dir structure
mkdir icons
for size in 16 22 24 32 36 48; do
  mkdir -p icons/${size}x${size}/apps
  convert pixmaps/logo.xpm -resize ${size}x${size} icons/${size}x${size}/apps/%{name}.png
done

# Convert doc to UTF-8
iconv --from=ISO-8859-1 --to=UTF-8 README > README.utf8
mv README.utf8 README

iconv --from=ISO-8859-1 --to=UTF-8 AUTHORS > AUTHORS.utf8
mv AUTHORS.utf8 AUTHORS

%build

%configure
%make_build

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor
cp -pr icons/*x* $RPM_BUILD_ROOT%{_datadir}/icons/hicolor

# Desktop file
desktop-file-install                                    \
  --dir=$RPM_BUILD_ROOT%{_datadir}/applications         \
  %{SOURCE1}

%files
%doc AUTHORS ChangeLog COPYING README
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_datadir}/icons/hicolor/*x*/apps/%{name}.png
%{_datadir}/applications/%{name}.desktop

%changelog
