Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: pkgconfig(gstreamer-0.10)
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: gstreamer-plugins-fc
Version: 0.2
Release: alt2_31
Summary: Future Composer input plugin for GStreamer
License: GPLv2+
URL: http://xmms-fc.sourceforge.net
Source0: http://downloads.sourceforge.net/xmms-fc/gstreamer-plugin-fc-%{version}.tar.bz2

BuildRequires: libfc14audiodecoder-devel

%if 0%{?fedora} < 31
BuildRequires: gstreamer-devel >= 0.10
# for %%{_libdir}/gstreamer-0.10
Requires: gstreamer
%endif

# fixed upstream
Patch0: gstfcdec-0.2-configure.patch
BuildRequires: automake autoconf libtool
# from cvs
Patch1: gstreamer-plugin-fc-0.2-gstreamer1.patch
Source44: import.info

%description
This is an input plugin for GStreamer which can play back Future Composer
music files from AMIGA. Song-length detection and seek are implemented, too.


%package -n gstreamer1-plugins-fc
Group: Sound
Summary: Future Composer input plugin for GStreamer 1.0.x
BuildRequires: gstreamer1.0-devel libgstreamer1.0-gir-devel
BuildRequires: gst-plugins1.0-devel gst-plugins1.0-gir-devel
# for %%{_libdir}/gstreamer-1.0
Requires: gstreamer1.0 gstreamer1.0-utils libgstreamer1.0-gir
%if 0%{?fedora} > 30
Obsoletes: gstreamer-plugins-fc < 0.2-21
%endif

%description -n gstreamer1-plugins-fc
This is an input plugin for GStreamer which can play back Future Composer
music files from AMIGA. Song-length detection and seek are implemented, too.

%prep
%setup -q -n gstreamer-plugin-fc-%{version}
# https://bugzilla.redhat.com/925503
#patch0 -p1
%patch1 -p1
mv configure.in configure.ac
libtoolize -f ; autoreconf -f -i


%build
%configure \
    --disable-static
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'


%if 0%{?fedora} < 31
%files
%doc --no-dereference COPYING
%doc README ChangeLog
%{_libdir}/gstreamer-0.10/*.so
%endif


%files -n gstreamer1-plugins-fc
%doc --no-dereference COPYING
%doc README ChangeLog
%{_libdir}/gstreamer-1.0/*.so


%changelog
