Group: Development/Tools
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		guilt
Version:	0.36
Release:	alt2_21
Summary:	Scripts to manage quilt-like patches on top of git

License:	GPLv2
URL:		http://repo.or.cz/guilt.git
Source:		%{name}-%{version}.tar.gz
Requires:	git, gawk, sed bash sh

BuildArch:	noarch
BuildRequires:	asciidoc asciidoc-a2x, xmlto, git-core

Patch0:		guilt-0.36-git-decorate.patch
Patch1:		guilt-0.36-filter-dd.patch
Patch2:		guilt-0.36-fix-regressions-newer-git.patch
Patch3:		guilt-0.36-fix-portability-problem-with-using-find-perm-111.patch
Source44: import.info

%description
Guilt allows one to use quilt functionality on top of a Git repository.
Changes are maintained as patches which are committed into Git.  Commits can
be removed or reordered, and the underlying patch can be refreshed based on
changes made in the working directory. The patch directory can also be
placed under revision control, so you can have a separate history of changes
made to your patches.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1


%build
make ASCIIDOC='asciidoc --unsafe' %{?_smp_mflags}

%install
make install PREFIX=$RPM_BUILD_ROOT/usr
make install-doc PREFIX=$RPM_BUILD_ROOT/usr mandir=$RPM_BUILD_ROOT/usr/share/man

%check
make test

%files
%doc COPYING Documentation/HOWTO Documentation/Contributing Documentation/Features
%{_bindir}/guilt
%{_prefix}/lib/*
%{_mandir}/man1/guilt*.1*
%{_mandir}/man7/guilt*.7*

%changelog
