Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commit      ae2d2966a7ceb65b0e4a0c72ca31bd7fceb76857
%global shortcommit %(c=%{commit}; echo ${c:0:7})
%global date        20190828

%global appname com.github.JannikHv.Gydl

Name:           gydl
Version:        0.1.1
Release:        alt1_13.%{date}git%{shortcommit}
Summary:        GUI wrapper around youtube-dl program

License:        GPLv3+
URL:            https://github.com/JannikHv/gydl
Source0:        https://github.com/JannikHv/gydl/archive/%{commit}/%{name}-%{version}.%{date}git%{shortcommit}.tar.gz

# fix(appdata): add type to launchable
# https://github.com/JannikHv/gydl/pull/34
Patch0:         https://github.com/JannikHv/gydl/pull/34.patch

BuildArch:      noarch

BuildRequires:  desktop-file-utils
BuildRequires:  intltool
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  meson
BuildRequires:  python3-devel
BuildRequires:  python3-module-youtube_dl youtube-dl
BuildRequires:  pkgconfig(gtk+-3.0)
BuildRequires:  pkgconfig(pygobject-3.0)
Requires:       icon-theme-hicolor
Requires:       python3-module-youtube_dl youtube-dl
Source44: import.info

%description
Gydl (Graphical Youtube-dl) is a GUI wrapper around the already existing
youtube-dl program.

It's developed with a dialog driven experience in mind. This provides a quick
and easy video or audio downloads without disturbances.

%prep
%setup -q -n %{name}-%{commit}
%patch0 -p1


%build
%meson
%meson_build

%install
%meson_install
%find_lang Gydl

%check
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/%{appname}.appdata.xml
desktop-file-validate %{buildroot}%{_datadir}/applications/%{appname}.desktop

%files -f Gydl.lang
%doc --no-dereference LICENSE
%doc README.md
%{_bindir}/%{name}.py
%{_datadir}/applications/*.desktop
%{_datadir}/icons/hicolor/*/*/*.svg
%{_metainfodir}/*.appdata.xml

%changelog
