Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install /usr/bin/glib-gettextize hdhomerun
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This is the correct folder for firewalld service files, even on x86_64
# It is not used for shared objects
%global fw_services %{_prefix}/lib/firewalld/services

Name:           hdhomerun
Version:        20230719
Release:        alt1_3
Summary:        Silicon Dust HDHomeRun configuration utility

License:        LGPLv3 and GPLv3
URL:            http://www.silicondust.com/
Source0:        http://download.silicondust.com/hdhomerun/libhdhomerun_%{version}.tgz
Source1:        http://download.silicondust.com/hdhomerun/hdhomerun_config_gui_%{version}.tgz
Source2:        hdhomerun_config_gui.desktop
Source3:        %{name}.xml

BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires:  libicns-utils
BuildRequires:  desktop-file-utils

Requires:       libgail libgtk+2
Source44: import.info

%description
The configuration and firmware upgrade utility for Silicon Dust's
networked HDTV dual-tuner HDHomeRun device.

%package devel
Group: Development/Other
Summary: Developer tools for the hdhomerun library
Requires: hdhomerun = %{version}-%{release}

%description devel
The hdhumerun-devel package provides developer tools for the hdhomerun library.


%prep
%setup -q -c -a 1

# Fix up linefeeds, drop execute bit and don't strip binaries
#{__sed} -i 's/\r//' libhdhomerun/*
sed -i -e '/$(STRIP).*/d' -e 's/C\(PP\)\?FLAGS .=/C\1FLAGS ?=/' libhdhomerun/Makefile

# Convert files to utf8
for f in libhdhomerun/*; do
  /usr/bin/iconv -f iso-8859-1 -t utf-8 --output $f.new $f && mv $f.new $f
done


%build
pushd hdhomerun_config_gui
%configure
%make_build
popd

cat << __EOF__ > README.firmware
The HDHomeRun Firmwares are not redistributable, but the latest versions of
both the US ATSC and European DVB-T firmwares can always be obtained from
the Silicon Dust web site:

https://www.silicondust.com/support/linux/

__EOF__

pushd hdhomerun_config_gui/OSX
icns2png -x hdhr.icns
popd


%install
%makeinstall_std -C hdhomerun_config_gui

install -m0755 libhdhomerun/hdhomerun_config %{buildroot}%{_bindir}/

mkdir include
cp -a libhdhomerun/*.h include
sed -r 's|(^#include +["])(.*)(["] *$)|#include <hdhomerun/\2>|' \
    libhdhomerun/hdhomerun.h > include/hdhomerun.h
mkdir -p %{buildroot}%{_includedir}/hdhomerun
install -p include/*.h %{buildroot}%{_includedir}/hdhomerun/

desktop-file-install --dir=${RPM_BUILD_ROOT}%{_datadir}/applications %{SOURCE2}

for size in 16x16 32x32 128x128 256x256 512x512; do
    mkdir -p %{buildroot}%{_datadir}/icons/hicolor/${size}/apps
    install -m0755 hdhomerun_config_gui/OSX/hdhr_${size}x32.png \
    %{buildroot}%{_datadir}/icons/hicolor/${size}/apps/hdhr.png
done

# Install firewalld config
mkdir -p %{buildroot}%{fw_services}
install -pm 0644 %{SOURCE3} %{buildroot}%{fw_services}/

%files
%doc --no-dereference libhdhomerun/LICENSE hdhomerun_config_gui/COPYING
%doc libhdhomerun/README.md hdhomerun_config_gui/AUTHORS hdhomerun_config_gui/README README.firmware
# lib and cli are LGPLv3
%{_libdir}/libhdhomerun.so
%{_bindir}/hdhomerun_config
# gui is GPLv3
%{_bindir}/hdhomerun_config_gui
%{_datadir}/applications/hdhomerun_config_gui.desktop
%{_datadir}/icons/hicolor/*/apps/hdhr.png
%{fw_services}/%{name}.xml

%files devel
%dir %{_includedir}/hdhomerun
%{_includedir}/hdhomerun/*.h


%changelog
