Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: hesiod
Version: 3.2.1
Release: alt3_13
License: MIT
Summary: Shared libraries for querying the Hesiod naming service

Source: ftp://athena-dist.mit.edu/pub/ATHENA/hesiod/hesiod-%{version}.tar.gz
BuildRequires: autoconf, automake, libtool, libidn-devel
Obsoletes: hesinfo < 3.2
Source44: import.info

%description
Hesiod is a system which uses existing DNS functionality to provide access
to databases of information that changes infrequently.  It is often used to
distribute information kept in the /etc/passwd, /etc/group, and /etc/printcap
files, among others.

%package devel
Group: Development/Other
Summary: Development libraries and headers for Hesiod
Requires: hesiod = %{version}-%{release}

%description devel
Hesiod is a system which uses existing DNS functionality to provide access
to databases of information that changes infrequently.  It is often used to
distribute information which might otherwise kept in the /etc/passwd,
/etc/group, and /etc/printcap files over a network, eliminating the need to
ensure the files are synchronized among multiple hosts.  This package contains
the header files and libraries required for building programs which use Hesiod.

%prep
%setup -q
autoreconf -vif

%build
%configure --disable-static
make

%install
make install DESTDIR=$RPM_BUILD_ROOT
# Remove libtool archives and static libs
find %{buildroot} -type f -name "*.la" -delete

%files
%doc --no-dereference COPYING
%doc README NEWS
%{_bindir}/*
%{_libdir}/libhesiod.so.*
%{_mandir}/man1/*
%{_mandir}/man5/*

%files devel
%{_libdir}/libhesiod.so
%{_libdir}/pkgconfig/*
%{_includedir}/hesiod.h
%{_mandir}/man3/*

%changelog
